package io.fabric8.kubernetes.api.model.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class EndpointHintsFluent<A extends EndpointHintsFluent<A>> extends BaseFluent<A>{
  public EndpointHintsFluent() {
  }
  public EndpointHintsFluent(EndpointHints instance) {
    instance = (instance != null ? instance : new EndpointHints());

    if (instance != null) {
      this.withForZones(instance.getForZones());
      this.withForZones(instance.getForZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<ForZoneBuilder> forZones = new ArrayList<ForZoneBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToForZones(int index,ForZone item) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    ForZoneBuilder builder = new ForZoneBuilder(item);
    if (index < 0 || index >= forZones.size()) { _visitables.get("forZones").add(builder); forZones.add(builder); } else { _visitables.get("forZones").add(index, builder); forZones.add(index, builder);}
    return (A)this;
  }
  public A setToForZones(int index,ForZone item) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    ForZoneBuilder builder = new ForZoneBuilder(item);
    if (index < 0 || index >= forZones.size()) { _visitables.get("forZones").add(builder); forZones.add(builder); } else { _visitables.get("forZones").set(index, builder); forZones.set(index, builder);}
    return (A)this;
  }
  public A addToForZones(io.fabric8.kubernetes.api.model.discovery.v1beta1.ForZone... items) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").add(builder);this.forZones.add(builder);} return (A)this;
  }
  public A addAllToForZones(Collection<ForZone> items) {
    if (this.forZones == null) {this.forZones = new ArrayList<ForZoneBuilder>();}
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").add(builder);this.forZones.add(builder);} return (A)this;
  }
  public A removeFromForZones(io.fabric8.kubernetes.api.model.discovery.v1beta1.ForZone... items) {
    if (this.forZones == null) return (A)this;
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").remove(builder); this.forZones.remove(builder);} return (A)this;
  }
  public A removeAllFromForZones(Collection<ForZone> items) {
    if (this.forZones == null) return (A)this;
    for (ForZone item : items) {ForZoneBuilder builder = new ForZoneBuilder(item);_visitables.get("forZones").remove(builder); this.forZones.remove(builder);} return (A)this;
  }
  public A removeMatchingFromForZones(Predicate<ForZoneBuilder> predicate) {
    if (forZones == null) return (A) this;
    final Iterator<ForZoneBuilder> each = forZones.iterator();
    final List visitables = _visitables.get("forZones");
    while (each.hasNext()) {
      ForZoneBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<ForZone> buildForZones() {
    return forZones != null ? build(forZones) : null;
  }
  public ForZone buildForZone(int index) {
    return this.forZones.get(index).build();
  }
  public ForZone buildFirstForZone() {
    return this.forZones.get(0).build();
  }
  public ForZone buildLastForZone() {
    return this.forZones.get(forZones.size() - 1).build();
  }
  public ForZone buildMatchingForZone(Predicate<ForZoneBuilder> predicate) {
    for (ForZoneBuilder item: forZones) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingForZone(Predicate<ForZoneBuilder> predicate) {
    for (ForZoneBuilder item: forZones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withForZones(List<ForZone> forZones) {
    if (this.forZones != null) { _visitables.get("forZones").clear();}
    if (forZones != null) {this.forZones = new ArrayList(); for (ForZone item : forZones){this.addToForZones(item);}} else { this.forZones = null;} return (A) this;
  }
  public A withForZones(io.fabric8.kubernetes.api.model.discovery.v1beta1.ForZone... forZones) {
    if (this.forZones != null) {this.forZones.clear(); _visitables.remove("forZones"); }
    if (forZones != null) {for (ForZone item :forZones){ this.addToForZones(item);}} return (A) this;
  }
  public boolean hasForZones() {
    return forZones != null && !forZones.isEmpty();
  }
  public A addNewForZone(String name) {
    return (A)addToForZones(new ForZone(name));
  }
  public ForZonesNested<A> addNewForZone() {
    return new ForZonesNested(-1, null);
  }
  public ForZonesNested<A> addNewForZoneLike(ForZone item) {
    return new ForZonesNested(-1, item);
  }
  public ForZonesNested<A> setNewForZoneLike(int index,ForZone item) {
    return new ForZonesNested(index, item);
  }
  public ForZonesNested<A> editForZone(int index) {
    if (forZones.size() <= index) throw new RuntimeException("Can't edit forZones. Index exceeds size.");
    return setNewForZoneLike(index, buildForZone(index));
  }
  public ForZonesNested<A> editFirstForZone() {
    if (forZones.size() == 0) throw new RuntimeException("Can't edit first forZones. The list is empty.");
    return setNewForZoneLike(0, buildForZone(0));
  }
  public ForZonesNested<A> editLastForZone() {
    int index = forZones.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last forZones. The list is empty.");
    return setNewForZoneLike(index, buildForZone(index));
  }
  public ForZonesNested<A> editMatchingForZone(Predicate<ForZoneBuilder> predicate) {
    int index = -1;
    for (int i=0;i<forZones.size();i++) { 
    if (predicate.test(forZones.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching forZones. No match found.");
    return setNewForZoneLike(index, buildForZone(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EndpointHintsFluent that = (EndpointHintsFluent) o;
    if (!java.util.Objects.equals(forZones, that.forZones)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(forZones,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (forZones != null && !forZones.isEmpty()) { sb.append("forZones:"); sb.append(forZones + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ForZonesNested<N> extends ForZoneFluent<ForZonesNested<N>> implements Nested<N>{
    ForZonesNested(int index,ForZone item) {
      this.index = index;
      this.builder = new ForZoneBuilder(this, item);
    }
    ForZoneBuilder builder;
    int index;
    public N and() {
      return (N) EndpointHintsFluent.this.setToForZones(index,builder.build());
    }
    public N endForZone() {
      return and();
    }
    
  }
  
}