package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointSliceListBuilder extends EndpointSliceListFluent<EndpointSliceListBuilder> implements VisitableBuilder<EndpointSliceList,EndpointSliceListBuilder>{
  public EndpointSliceListBuilder() {
    this(false);
  }
  public EndpointSliceListBuilder(Boolean validationEnabled) {
    this(new EndpointSliceList(), validationEnabled);
  }
  public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointSliceList(), validationEnabled);
  }
  public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent,EndpointSliceList instance) {
    this(fluent, instance, false);
  }
  public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent,EndpointSliceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EndpointSliceList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointSliceListBuilder(EndpointSliceList instance) {
    this(instance,false);
  }
  public EndpointSliceListBuilder(EndpointSliceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EndpointSliceList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointSliceListFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointSliceList build() {
    EndpointSliceList buildable = new EndpointSliceList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}