package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointHintsBuilder extends EndpointHintsFluent<EndpointHintsBuilder> implements VisitableBuilder<EndpointHints,EndpointHintsBuilder>{
  public EndpointHintsBuilder() {
    this(false);
  }
  public EndpointHintsBuilder(Boolean validationEnabled) {
    this(new EndpointHints(), validationEnabled);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointHints(), validationEnabled);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent,EndpointHints instance) {
    this(fluent, instance, false);
  }
  public EndpointHintsBuilder(EndpointHintsFluent<?> fluent,EndpointHints instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EndpointHints());

    if (instance != null) {
      fluent.withForZones(instance.getForZones());
      fluent.withForZones(instance.getForZones());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EndpointHintsBuilder(EndpointHints instance) {
    this(instance,false);
  }
  public EndpointHintsBuilder(EndpointHints instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EndpointHints());

    if (instance != null) {
      this.withForZones(instance.getForZones());
      this.withForZones(instance.getForZones());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EndpointHintsFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointHints build() {
    EndpointHints buildable = new EndpointHints(fluent.buildForZones());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}