package io.fabric8.kubernetes.api.model.discovery.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EndpointConditionsBuilder extends EndpointConditionsFluentImpl<EndpointConditionsBuilder> implements VisitableBuilder<EndpointConditions,EndpointConditionsBuilder>{
  public EndpointConditionsBuilder() {
    this(false);
  }
  public EndpointConditionsBuilder(Boolean validationEnabled) {
    this(new EndpointConditions(), validationEnabled);
  }
  public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent) {
    this(fluent, false);
  }
  public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EndpointConditions(), validationEnabled);
  }
  public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,EndpointConditions instance) {
    this(fluent, instance, false);
  }
  public EndpointConditionsBuilder(EndpointConditionsFluent<?> fluent,EndpointConditions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withReady(instance.getReady()); 
    fluent.withServing(instance.getServing()); 
    fluent.withTerminating(instance.getTerminating()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EndpointConditionsBuilder(EndpointConditions instance) {
    this(instance,false);
  }
  public EndpointConditionsBuilder(EndpointConditions instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withReady(instance.getReady()); 
    this.withServing(instance.getServing()); 
    this.withTerminating(instance.getTerminating()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  EndpointConditionsFluent<?> fluent;
  Boolean validationEnabled;
  public EndpointConditions build() {
    EndpointConditions buildable = new EndpointConditions(fluent.getReady(),fluent.getServing(),fluent.getTerminating());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}