package io.fabric8.kubernetes.api.model.discovery;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class EndpointSliceListBuilder extends EndpointSliceListFluentImpl<EndpointSliceListBuilder> implements VisitableBuilder<EndpointSliceList,EndpointSliceListBuilder> {

    EndpointSliceListFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointSliceListBuilder() { 
        this(true);
    }


    public EndpointSliceListBuilder(Boolean validationEnabled) { 
        this(new EndpointSliceList(), validationEnabled);
    }


    public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent) { 
        this(fluent, true);
    }


    public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new EndpointSliceList(), validationEnabled);
    }


    public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent,EndpointSliceList instance) { 
        this(fluent, instance, true);
    }


    public EndpointSliceListBuilder(EndpointSliceListFluent<?> fluent,EndpointSliceList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public EndpointSliceListBuilder(EndpointSliceList instance) { 
        this(instance,true);
    }


    public EndpointSliceListBuilder(EndpointSliceList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public EndpointSliceList build() {
        EndpointSliceList buildable = new EndpointSliceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EndpointSliceListBuilder that = (EndpointSliceListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
