/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Context;
import io.fabric8.kubernetes.api.model.ContextBuilder;
import io.fabric8.kubernetes.api.model.ContextFluent;
import io.fabric8.kubernetes.api.model.NamedContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NamedContextFluent<A extends NamedContextFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ContextBuilder context;
    private String name;

    public NamedContextFluent() {
    }

    public NamedContextFluent(NamedContext instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public Context buildContext() {
        return this.context != null ? this.context.build() : null;
    }

    protected void copyInstance(NamedContext instance) {
        NamedContext namedContext = instance = instance != null ? instance : new NamedContext();
        if (instance != null) {
            this.withContext(instance.getContext());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ContextNested<A> editContext() {
        return this.withNewContextLike(Optional.ofNullable(this.buildContext()).orElse(null));
    }

    public ContextNested<A> editOrNewContext() {
        return this.withNewContextLike(Optional.ofNullable(this.buildContext()).orElse(new ContextBuilder().build()));
    }

    public ContextNested<A> editOrNewContextLike(Context item) {
        return this.withNewContextLike(Optional.ofNullable(this.buildContext()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedContextFluent that = (NamedContextFluent)((Object)o);
        if (!Objects.equals((Object)this.context, (Object)that.context)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasContext() {
        return this.context != null;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.context, this.name, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.context != null) {
            sb.append("context:");
            sb.append((Object)this.context);
            sb.append(",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withContext(Context context) {
        this._visitables.remove((Object)"context");
        if (context != null) {
            this.context = new ContextBuilder(context);
            this._visitables.get((Object)"context").add(this.context);
        } else {
            this.context = null;
            this._visitables.get((Object)"context").remove((Object)this.context);
        }
        return (A)((Object)this);
    }

    public A withName(String name) {
        this.name = name;
        return (A)((Object)this);
    }

    public ContextNested<A> withNewContext() {
        return new ContextNested(null);
    }

    public ContextNested<A> withNewContextLike(Context item) {
        return new ContextNested(item);
    }

    public class ContextNested<N>
    extends ContextFluent<ContextNested<N>>
    implements Nested<N> {
        ContextBuilder builder;

        ContextNested(Context item) {
            this.builder = new ContextBuilder(this, item);
        }

        public N and() {
            return (N)NamedContextFluent.this.withContext(this.builder.build());
        }

        public N endContext() {
            return this.and();
        }
    }
}

