package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import java.lang.StringBuilder;
import java.lang.SuppressWarnings;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerUserFluent<A extends io.fabric8.kubernetes.api.model.ContainerUserFluent<A>> extends BaseFluent<A>{

  private Map<String,Object> additionalProperties;
  private LinuxContainerUserBuilder linux;

  public ContainerUserFluent() {
  }
  
  public ContainerUserFluent(ContainerUser instance) {
    this.copyInstance(instance);
  }

  public A addToAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null && map != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (map != null) {
      this.additionalProperties.putAll(map);
    }
    return (A) this;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if (this.additionalProperties == null && key != null && value != null) {
      this.additionalProperties = new LinkedHashMap();
    }
    if (key != null && value != null) {
      this.additionalProperties.put(key, value);
    }
    return (A) this;
  }
  
  public LinuxContainerUser buildLinux() {
    return this.linux != null ? this.linux.build() : null;
  }
  
  protected void copyInstance(ContainerUser instance) {
    instance = instance != null ? instance : new ContainerUser();
    if (instance != null) {
        this.withLinux(instance.getLinux());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  
  public LinuxNested<A> editLinux() {
    return this.withNewLinuxLike(Optional.ofNullable(this.buildLinux()).orElse(null));
  }
  
  public LinuxNested<A> editOrNewLinux() {
    return this.withNewLinuxLike(Optional.ofNullable(this.buildLinux()).orElse(new LinuxContainerUserBuilder().build()));
  }
  
  public LinuxNested<A> editOrNewLinuxLike(LinuxContainerUser item) {
    return this.withNewLinuxLike(Optional.ofNullable(this.buildLinux()).orElse(item));
  }
  
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || this.getClass() != o.getClass()) {
      return false;
    }
    if (!(super.equals(o))) {
      return false;
    }
    ContainerUserFluent that = (ContainerUserFluent) o;
    if (!(Objects.equals(linux, that.linux))) {
      return false;
    }
    if (!(Objects.equals(additionalProperties, that.additionalProperties))) {
      return false;
    }
    return true;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean hasLinux() {
    return this.linux != null;
  }
  
  public int hashCode() {
    return Objects.hash(linux, additionalProperties);
  }
  
  public A removeFromAdditionalProperties(String key) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (key != null && this.additionalProperties != null) {
      this.additionalProperties.remove(key);
    }
    return (A) this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if (this.additionalProperties == null) {
      return (A) this;
    }
    if (map != null) {
      for (Object key : map.keySet()) {
        if (this.additionalProperties != null) {
          this.additionalProperties.remove(key);
        }
      }
    }
    return (A) this;
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (!(linux == null)) {
        sb.append("linux:");
        sb.append(linux);
        sb.append(",");
    }
    if (!(additionalProperties == null) && !(additionalProperties.isEmpty())) {
        sb.append("additionalProperties:");
        sb.append(additionalProperties);
    }
    sb.append("}");
    return sb.toString();
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public A withLinux(LinuxContainerUser linux) {
    this._visitables.remove("linux");
    if (linux != null) {
        this.linux = new LinuxContainerUserBuilder(linux);
        this._visitables.get("linux").add(this.linux);
    } else {
        this.linux = null;
        this._visitables.get("linux").remove(this.linux);
    }
    return (A) this;
  }
  
  public LinuxNested<A> withNewLinux() {
    return new LinuxNested(null);
  }
  
  public LinuxNested<A> withNewLinuxLike(LinuxContainerUser item) {
    return new LinuxNested(item);
  }
  public class LinuxNested<N> extends LinuxContainerUserFluent<LinuxNested<N>> implements Nested<N>{
  
    LinuxContainerUserBuilder builder;
  
    LinuxNested(LinuxContainerUser item) {
      this.builder = new LinuxContainerUserBuilder(this, item);
    }
  
    public N and() {
      return (N) ContainerUserFluent.this.withLinux(builder.build());
    }
    
    public N endLinux() {
      return and();
    }
    
  }
}