package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.NodeSystemInfoFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.NodeSystemInfo;
import io.fabric8.kubernetes.api.model.NodeSystemInfoBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineStatusFluent<A extends MachineStatusFluent<A>> extends BaseFluent<A>{
  public MachineStatusFluent() {
  }
  
  public MachineStatusFluent(MachineStatus instance) {
    this.copyInstance(instance);
  }
  private ArrayList<MachineAddressBuilder> addresses = new ArrayList<MachineAddressBuilder>();
  private Boolean bootstrapReady;
  private String certificatesExpiryDate;
  private ArrayList<ConditionBuilder> conditions = new ArrayList<ConditionBuilder>();
  private MachineDeletionStatusBuilder deletion;
  private String failureMessage;
  private String failureReason;
  private Boolean infrastructureReady;
  private String lastUpdated;
  private NodeSystemInfoBuilder nodeInfo;
  private ObjectReferenceBuilder nodeRef;
  private Long observedGeneration;
  private String phase;
  private MachineV1Beta2StatusBuilder v1beta2;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineStatus instance) {
    instance = (instance != null ? instance : new MachineStatus());
    if (instance != null) {
          this.withAddresses(instance.getAddresses());
          this.withBootstrapReady(instance.getBootstrapReady());
          this.withCertificatesExpiryDate(instance.getCertificatesExpiryDate());
          this.withConditions(instance.getConditions());
          this.withDeletion(instance.getDeletion());
          this.withFailureMessage(instance.getFailureMessage());
          this.withFailureReason(instance.getFailureReason());
          this.withInfrastructureReady(instance.getInfrastructureReady());
          this.withLastUpdated(instance.getLastUpdated());
          this.withNodeInfo(instance.getNodeInfo());
          this.withNodeRef(instance.getNodeRef());
          this.withObservedGeneration(instance.getObservedGeneration());
          this.withPhase(instance.getPhase());
          this.withV1beta2(instance.getV1beta2());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAddresses(int index,MachineAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddressBuilder>();}
    MachineAddressBuilder builder = new MachineAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) {
        _visitables.get("addresses").add(builder);
        addresses.add(builder);
    } else {
        _visitables.get("addresses").add(builder);
        addresses.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToAddresses(int index,MachineAddress item) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddressBuilder>();}
    MachineAddressBuilder builder = new MachineAddressBuilder(item);
    if (index < 0 || index >= addresses.size()) {
        _visitables.get("addresses").add(builder);
        addresses.add(builder);
    } else {
        _visitables.get("addresses").add(builder);
        addresses.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToAddresses(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddressBuilder>();}
    for (MachineAddress item : items) {MachineAddressBuilder builder = new MachineAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  
  public A addAllToAddresses(Collection<MachineAddress> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<MachineAddressBuilder>();}
    for (MachineAddress item : items) {MachineAddressBuilder builder = new MachineAddressBuilder(item);_visitables.get("addresses").add(builder);this.addresses.add(builder);} return (A)this;
  }
  
  public A removeFromAddresses(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress... items) {
    if (this.addresses == null) return (A)this;
    for (MachineAddress item : items) {MachineAddressBuilder builder = new MachineAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAddresses(Collection<MachineAddress> items) {
    if (this.addresses == null) return (A)this;
    for (MachineAddress item : items) {MachineAddressBuilder builder = new MachineAddressBuilder(item);_visitables.get("addresses").remove(builder); this.addresses.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAddresses(Predicate<MachineAddressBuilder> predicate) {
    if (addresses == null) return (A) this;
    final Iterator<MachineAddressBuilder> each = addresses.iterator();
    final List visitables = _visitables.get("addresses");
    while (each.hasNext()) {
      MachineAddressBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<MachineAddress> buildAddresses() {
    return this.addresses != null ? build(addresses) : null;
  }
  
  public MachineAddress buildAddress(int index) {
    return this.addresses.get(index).build();
  }
  
  public MachineAddress buildFirstAddress() {
    return this.addresses.get(0).build();
  }
  
  public MachineAddress buildLastAddress() {
    return this.addresses.get(addresses.size() - 1).build();
  }
  
  public MachineAddress buildMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
      for (MachineAddressBuilder item : addresses) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
      for (MachineAddressBuilder item : addresses) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAddresses(List<MachineAddress> addresses) {
    if (this.addresses != null) {
      this._visitables.get("addresses").clear();
    }
    if (addresses != null) {
        this.addresses = new ArrayList();
        for (MachineAddress item : addresses) {
          this.addToAddresses(item);
        }
    } else {
      this.addresses = null;
    }
    return (A) this;
  }
  
  public A withAddresses(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.MachineAddress... addresses) {
    if (this.addresses != null) {
        this.addresses.clear();
        _visitables.remove("addresses");
    }
    if (addresses != null) {
      for (MachineAddress item : addresses) {
        this.addToAddresses(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAddresses() {
    return this.addresses != null && !this.addresses.isEmpty();
  }
  
  public A addNewAddress(String address,String type) {
    return (A)addToAddresses(new MachineAddress(address, type));
  }
  
  public AddressesNested<A> addNewAddress() {
    return new AddressesNested(-1, null);
  }
  
  public AddressesNested<A> addNewAddressLike(MachineAddress item) {
    return new AddressesNested(-1, item);
  }
  
  public AddressesNested<A> setNewAddressLike(int index,MachineAddress item) {
    return new AddressesNested(index, item);
  }
  
  public AddressesNested<A> editAddress(int index) {
    if (addresses.size() <= index) throw new RuntimeException("Can't edit addresses. Index exceeds size.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public AddressesNested<A> editFirstAddress() {
    if (addresses.size() == 0) throw new RuntimeException("Can't edit first addresses. The list is empty.");
    return setNewAddressLike(0, buildAddress(0));
  }
  
  public AddressesNested<A> editLastAddress() {
    int index = addresses.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last addresses. The list is empty.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public AddressesNested<A> editMatchingAddress(Predicate<MachineAddressBuilder> predicate) {
    int index = -1;
    for (int i=0;i<addresses.size();i++) { 
    if (predicate.test(addresses.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching addresses. No match found.");
    return setNewAddressLike(index, buildAddress(index));
  }
  
  public Boolean getBootstrapReady() {
    return this.bootstrapReady;
  }
  
  public A withBootstrapReady(Boolean bootstrapReady) {
    this.bootstrapReady = bootstrapReady;
    return (A) this;
  }
  
  public boolean hasBootstrapReady() {
    return this.bootstrapReady != null;
  }
  
  public String getCertificatesExpiryDate() {
    return this.certificatesExpiryDate;
  }
  
  public A withCertificatesExpiryDate(String certificatesExpiryDate) {
    this.certificatesExpiryDate = certificatesExpiryDate;
    return (A) this;
  }
  
  public boolean hasCertificatesExpiryDate() {
    return this.certificatesExpiryDate != null;
  }
  
  public A addToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToConditions(int index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    ConditionBuilder builder = new ConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) {
        _visitables.get("conditions").add(builder);
        conditions.add(builder);
    } else {
        _visitables.get("conditions").add(builder);
        conditions.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<ConditionBuilder>();}
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition... items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<Condition> items) {
    if (this.conditions == null) return (A)this;
    for (Condition item : items) {ConditionBuilder builder = new ConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<ConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<ConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      ConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Condition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public Condition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public Condition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public Condition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public Condition buildMatchingCondition(Predicate<ConditionBuilder> predicate) {
      for (ConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<ConditionBuilder> predicate) {
      for (ConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<Condition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (Condition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.clusterapi.v1beta1.Condition... conditions) {
    if (this.conditions != null) {
        this.conditions.clear();
        _visitables.remove("conditions");
    }
    if (conditions != null) {
      for (Condition item : conditions) {
        this.addToConditions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(Condition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,Condition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<ConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public MachineDeletionStatus buildDeletion() {
    return this.deletion != null ? this.deletion.build() : null;
  }
  
  public A withDeletion(MachineDeletionStatus deletion) {
    this._visitables.remove("deletion");
    if (deletion != null) {
        this.deletion = new MachineDeletionStatusBuilder(deletion);
        this._visitables.get("deletion").add(this.deletion);
    } else {
        this.deletion = null;
        this._visitables.get("deletion").remove(this.deletion);
    }
    return (A) this;
  }
  
  public boolean hasDeletion() {
    return this.deletion != null;
  }
  
  public A withNewDeletion(String nodeDrainStartTime,String waitForNodeVolumeDetachStartTime) {
    return (A)withDeletion(new MachineDeletionStatus(nodeDrainStartTime, waitForNodeVolumeDetachStartTime));
  }
  
  public DeletionNested<A> withNewDeletion() {
    return new DeletionNested(null);
  }
  
  public DeletionNested<A> withNewDeletionLike(MachineDeletionStatus item) {
    return new DeletionNested(item);
  }
  
  public DeletionNested<A> editDeletion() {
    return withNewDeletionLike(java.util.Optional.ofNullable(buildDeletion()).orElse(null));
  }
  
  public DeletionNested<A> editOrNewDeletion() {
    return withNewDeletionLike(java.util.Optional.ofNullable(buildDeletion()).orElse(new MachineDeletionStatusBuilder().build()));
  }
  
  public DeletionNested<A> editOrNewDeletionLike(MachineDeletionStatus item) {
    return withNewDeletionLike(java.util.Optional.ofNullable(buildDeletion()).orElse(item));
  }
  
  public String getFailureMessage() {
    return this.failureMessage;
  }
  
  public A withFailureMessage(String failureMessage) {
    this.failureMessage = failureMessage;
    return (A) this;
  }
  
  public boolean hasFailureMessage() {
    return this.failureMessage != null;
  }
  
  public String getFailureReason() {
    return this.failureReason;
  }
  
  public A withFailureReason(String failureReason) {
    this.failureReason = failureReason;
    return (A) this;
  }
  
  public boolean hasFailureReason() {
    return this.failureReason != null;
  }
  
  public Boolean getInfrastructureReady() {
    return this.infrastructureReady;
  }
  
  public A withInfrastructureReady(Boolean infrastructureReady) {
    this.infrastructureReady = infrastructureReady;
    return (A) this;
  }
  
  public boolean hasInfrastructureReady() {
    return this.infrastructureReady != null;
  }
  
  public String getLastUpdated() {
    return this.lastUpdated;
  }
  
  public A withLastUpdated(String lastUpdated) {
    this.lastUpdated = lastUpdated;
    return (A) this;
  }
  
  public boolean hasLastUpdated() {
    return this.lastUpdated != null;
  }
  
  public NodeSystemInfo buildNodeInfo() {
    return this.nodeInfo != null ? this.nodeInfo.build() : null;
  }
  
  public A withNodeInfo(NodeSystemInfo nodeInfo) {
    this._visitables.remove("nodeInfo");
    if (nodeInfo != null) {
        this.nodeInfo = new NodeSystemInfoBuilder(nodeInfo);
        this._visitables.get("nodeInfo").add(this.nodeInfo);
    } else {
        this.nodeInfo = null;
        this._visitables.get("nodeInfo").remove(this.nodeInfo);
    }
    return (A) this;
  }
  
  public boolean hasNodeInfo() {
    return this.nodeInfo != null;
  }
  
  public NodeInfoNested<A> withNewNodeInfo() {
    return new NodeInfoNested(null);
  }
  
  public NodeInfoNested<A> withNewNodeInfoLike(NodeSystemInfo item) {
    return new NodeInfoNested(item);
  }
  
  public NodeInfoNested<A> editNodeInfo() {
    return withNewNodeInfoLike(java.util.Optional.ofNullable(buildNodeInfo()).orElse(null));
  }
  
  public NodeInfoNested<A> editOrNewNodeInfo() {
    return withNewNodeInfoLike(java.util.Optional.ofNullable(buildNodeInfo()).orElse(new NodeSystemInfoBuilder().build()));
  }
  
  public NodeInfoNested<A> editOrNewNodeInfoLike(NodeSystemInfo item) {
    return withNewNodeInfoLike(java.util.Optional.ofNullable(buildNodeInfo()).orElse(item));
  }
  
  public ObjectReference buildNodeRef() {
    return this.nodeRef != null ? this.nodeRef.build() : null;
  }
  
  public A withNodeRef(ObjectReference nodeRef) {
    this._visitables.remove("nodeRef");
    if (nodeRef != null) {
        this.nodeRef = new ObjectReferenceBuilder(nodeRef);
        this._visitables.get("nodeRef").add(this.nodeRef);
    } else {
        this.nodeRef = null;
        this._visitables.get("nodeRef").remove(this.nodeRef);
    }
    return (A) this;
  }
  
  public boolean hasNodeRef() {
    return this.nodeRef != null;
  }
  
  public NodeRefNested<A> withNewNodeRef() {
    return new NodeRefNested(null);
  }
  
  public NodeRefNested<A> withNewNodeRefLike(ObjectReference item) {
    return new NodeRefNested(item);
  }
  
  public NodeRefNested<A> editNodeRef() {
    return withNewNodeRefLike(java.util.Optional.ofNullable(buildNodeRef()).orElse(null));
  }
  
  public NodeRefNested<A> editOrNewNodeRef() {
    return withNewNodeRefLike(java.util.Optional.ofNullable(buildNodeRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public NodeRefNested<A> editOrNewNodeRefLike(ObjectReference item) {
    return withNewNodeRefLike(java.util.Optional.ofNullable(buildNodeRef()).orElse(item));
  }
  
  public Long getObservedGeneration() {
    return this.observedGeneration;
  }
  
  public A withObservedGeneration(Long observedGeneration) {
    this.observedGeneration = observedGeneration;
    return (A) this;
  }
  
  public boolean hasObservedGeneration() {
    return this.observedGeneration != null;
  }
  
  public String getPhase() {
    return this.phase;
  }
  
  public A withPhase(String phase) {
    this.phase = phase;
    return (A) this;
  }
  
  public boolean hasPhase() {
    return this.phase != null;
  }
  
  public MachineV1Beta2Status buildV1beta2() {
    return this.v1beta2 != null ? this.v1beta2.build() : null;
  }
  
  public A withV1beta2(MachineV1Beta2Status v1beta2) {
    this._visitables.remove("v1beta2");
    if (v1beta2 != null) {
        this.v1beta2 = new MachineV1Beta2StatusBuilder(v1beta2);
        this._visitables.get("v1beta2").add(this.v1beta2);
    } else {
        this.v1beta2 = null;
        this._visitables.get("v1beta2").remove(this.v1beta2);
    }
    return (A) this;
  }
  
  public boolean hasV1beta2() {
    return this.v1beta2 != null;
  }
  
  public V1beta2Nested<A> withNewV1beta2() {
    return new V1beta2Nested(null);
  }
  
  public V1beta2Nested<A> withNewV1beta2Like(MachineV1Beta2Status item) {
    return new V1beta2Nested(item);
  }
  
  public V1beta2Nested<A> editV1beta2() {
    return withNewV1beta2Like(java.util.Optional.ofNullable(buildV1beta2()).orElse(null));
  }
  
  public V1beta2Nested<A> editOrNewV1beta2() {
    return withNewV1beta2Like(java.util.Optional.ofNullable(buildV1beta2()).orElse(new MachineV1Beta2StatusBuilder().build()));
  }
  
  public V1beta2Nested<A> editOrNewV1beta2Like(MachineV1Beta2Status item) {
    return withNewV1beta2Like(java.util.Optional.ofNullable(buildV1beta2()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineStatusFluent that = (MachineStatusFluent) o;
    if (!java.util.Objects.equals(addresses, that.addresses)) return false;
    if (!java.util.Objects.equals(bootstrapReady, that.bootstrapReady)) return false;
    if (!java.util.Objects.equals(certificatesExpiryDate, that.certificatesExpiryDate)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(deletion, that.deletion)) return false;
    if (!java.util.Objects.equals(failureMessage, that.failureMessage)) return false;
    if (!java.util.Objects.equals(failureReason, that.failureReason)) return false;
    if (!java.util.Objects.equals(infrastructureReady, that.infrastructureReady)) return false;
    if (!java.util.Objects.equals(lastUpdated, that.lastUpdated)) return false;
    if (!java.util.Objects.equals(nodeInfo, that.nodeInfo)) return false;
    if (!java.util.Objects.equals(nodeRef, that.nodeRef)) return false;
    if (!java.util.Objects.equals(observedGeneration, that.observedGeneration)) return false;
    if (!java.util.Objects.equals(phase, that.phase)) return false;
    if (!java.util.Objects.equals(v1beta2, that.v1beta2)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(addresses,  bootstrapReady,  certificatesExpiryDate,  conditions,  deletion,  failureMessage,  failureReason,  infrastructureReady,  lastUpdated,  nodeInfo,  nodeRef,  observedGeneration,  phase,  v1beta2,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (bootstrapReady != null) { sb.append("bootstrapReady:"); sb.append(bootstrapReady + ","); }
    if (certificatesExpiryDate != null) { sb.append("certificatesExpiryDate:"); sb.append(certificatesExpiryDate + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (deletion != null) { sb.append("deletion:"); sb.append(deletion + ","); }
    if (failureMessage != null) { sb.append("failureMessage:"); sb.append(failureMessage + ","); }
    if (failureReason != null) { sb.append("failureReason:"); sb.append(failureReason + ","); }
    if (infrastructureReady != null) { sb.append("infrastructureReady:"); sb.append(infrastructureReady + ","); }
    if (lastUpdated != null) { sb.append("lastUpdated:"); sb.append(lastUpdated + ","); }
    if (nodeInfo != null) { sb.append("nodeInfo:"); sb.append(nodeInfo + ","); }
    if (nodeRef != null) { sb.append("nodeRef:"); sb.append(nodeRef + ","); }
    if (observedGeneration != null) { sb.append("observedGeneration:"); sb.append(observedGeneration + ","); }
    if (phase != null) { sb.append("phase:"); sb.append(phase + ","); }
    if (v1beta2 != null) { sb.append("v1beta2:"); sb.append(v1beta2 + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withBootstrapReady() {
    return withBootstrapReady(true);
  }
  
  public A withInfrastructureReady() {
    return withInfrastructureReady(true);
  }
  public class AddressesNested<N> extends MachineAddressFluent<AddressesNested<N>> implements Nested<N>{
    AddressesNested(int index,MachineAddress item) {
      this.index = index;
      this.builder = new MachineAddressBuilder(this, item);
    }
    MachineAddressBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineStatusFluent.this.setToAddresses(index,builder.build());
    }
    
    public N endAddress() {
      return and();
    }
    
  
  }
  public class ConditionsNested<N> extends ConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,Condition item) {
      this.index = index;
      this.builder = new ConditionBuilder(this, item);
    }
    ConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) MachineStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class DeletionNested<N> extends MachineDeletionStatusFluent<DeletionNested<N>> implements Nested<N>{
    DeletionNested(MachineDeletionStatus item) {
      this.builder = new MachineDeletionStatusBuilder(this, item);
    }
    MachineDeletionStatusBuilder builder;
    
    public N and() {
      return (N) MachineStatusFluent.this.withDeletion(builder.build());
    }
    
    public N endDeletion() {
      return and();
    }
    
  
  }
  public class NodeInfoNested<N> extends NodeSystemInfoFluent<NodeInfoNested<N>> implements Nested<N>{
    NodeInfoNested(NodeSystemInfo item) {
      this.builder = new NodeSystemInfoBuilder(this, item);
    }
    NodeSystemInfoBuilder builder;
    
    public N and() {
      return (N) MachineStatusFluent.this.withNodeInfo(builder.build());
    }
    
    public N endNodeInfo() {
      return and();
    }
    
  
  }
  public class NodeRefNested<N> extends ObjectReferenceFluent<NodeRefNested<N>> implements Nested<N>{
    NodeRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) MachineStatusFluent.this.withNodeRef(builder.build());
    }
    
    public N endNodeRef() {
      return and();
    }
    
  
  }
  public class V1beta2Nested<N> extends MachineV1Beta2StatusFluent<V1beta2Nested<N>> implements Nested<N>{
    V1beta2Nested(MachineV1Beta2Status item) {
      this.builder = new MachineV1Beta2StatusBuilder(this, item);
    }
    MachineV1Beta2StatusBuilder builder;
    
    public N and() {
      return (N) MachineStatusFluent.this.withV1beta2(builder.build());
    }
    
    public N endV1beta2() {
      return and();
    }
    
  
  }

}