package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PersistentVolumeListBuilder extends PersistentVolumeListFluent<PersistentVolumeListBuilder> implements VisitableBuilder<PersistentVolumeList,PersistentVolumeListBuilder>{
  public PersistentVolumeListBuilder() {
    this(new PersistentVolumeList());
  }
  
  public PersistentVolumeListBuilder(PersistentVolumeListFluent<?> fluent) {
    this(fluent, new PersistentVolumeList());
  }
  
  public PersistentVolumeListBuilder(PersistentVolumeListFluent<?> fluent,PersistentVolumeList instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PersistentVolumeListBuilder(PersistentVolumeList instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PersistentVolumeListFluent<?> fluent;
  
  public PersistentVolumeList build() {
    PersistentVolumeList buildable = new PersistentVolumeList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}