package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeSwapStatusBuilder extends NodeSwapStatusFluent<NodeSwapStatusBuilder> implements VisitableBuilder<NodeSwapStatus,NodeSwapStatusBuilder>{
  public NodeSwapStatusBuilder() {
    this(new NodeSwapStatus());
  }
  
  public NodeSwapStatusBuilder(NodeSwapStatusFluent<?> fluent) {
    this(fluent, new NodeSwapStatus());
  }
  
  public NodeSwapStatusBuilder(NodeSwapStatusFluent<?> fluent,NodeSwapStatus instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeSwapStatusBuilder(NodeSwapStatus instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeSwapStatusFluent<?> fluent;
  
  public NodeSwapStatus build() {
    NodeSwapStatus buildable = new NodeSwapStatus(fluent.getCapacity());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}