package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NamedContextBuilder extends NamedContextFluent<NamedContextBuilder> implements VisitableBuilder<NamedContext,NamedContextBuilder>{
  public NamedContextBuilder() {
    this(new NamedContext());
  }
  
  public NamedContextBuilder(NamedContextFluent<?> fluent) {
    this(fluent, new NamedContext());
  }
  
  public NamedContextBuilder(NamedContextFluent<?> fluent,NamedContext instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NamedContextBuilder(NamedContext instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NamedContextFluent<?> fluent;
  
  public NamedContext build() {
    NamedContext buildable = new NamedContext(fluent.buildContext(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}