/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirement;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirementBuilder;
import io.fabric8.kubernetes.api.model.NodeSelectorRequirementFluent;
import io.fabric8.kubernetes.api.model.NodeSelectorTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NodeSelectorTermFluent<A extends NodeSelectorTermFluent<A>>
extends BaseFluent<A> {
    private ArrayList<NodeSelectorRequirementBuilder> matchExpressions = new ArrayList();
    private ArrayList<NodeSelectorRequirementBuilder> matchFields = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NodeSelectorTermFluent() {
    }

    public NodeSelectorTermFluent(NodeSelectorTerm instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(NodeSelectorTerm instance) {
        NodeSelectorTerm nodeSelectorTerm = instance = instance != null ? instance : new NodeSelectorTerm();
        if (instance != null) {
            this.withMatchExpressions(instance.getMatchExpressions());
            this.withMatchFields(instance.getMatchFields());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToMatchExpressions(int index, NodeSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMatchExpressions(int index, NodeSelectorRequirement item) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchExpressions.size()) {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        } else {
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMatchExpressions(NodeSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMatchExpressions(Collection<NodeSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            this.matchExpressions = new ArrayList();
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").add(builder);
            this.matchExpressions.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchExpressions(NodeSelectorRequirement ... items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").remove((Object)builder);
            this.matchExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatchExpressions(Collection<NodeSelectorRequirement> items) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchExpressions").remove((Object)builder);
            this.matchExpressions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatchExpressions(Predicate<NodeSelectorRequirementBuilder> predicate) {
        if (this.matchExpressions == null) {
            return (A)((Object)this);
        }
        Iterator<NodeSelectorRequirementBuilder> each = this.matchExpressions.iterator();
        List visitables = this._visitables.get((Object)"matchExpressions");
        while (each.hasNext()) {
            NodeSelectorRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NodeSelectorRequirement> buildMatchExpressions() {
        return this.matchExpressions != null ? NodeSelectorTermFluent.build(this.matchExpressions) : null;
    }

    public NodeSelectorRequirement buildMatchExpression(int index) {
        return this.matchExpressions.get(index).build();
    }

    public NodeSelectorRequirement buildFirstMatchExpression() {
        return this.matchExpressions.get(0).build();
    }

    public NodeSelectorRequirement buildLastMatchExpression() {
        return this.matchExpressions.get(this.matchExpressions.size() - 1).build();
    }

    public NodeSelectorRequirement buildMatchingMatchExpression(Predicate<NodeSelectorRequirementBuilder> predicate) {
        for (NodeSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchExpression(Predicate<NodeSelectorRequirementBuilder> predicate) {
        for (NodeSelectorRequirementBuilder item : this.matchExpressions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchExpressions(List<NodeSelectorRequirement> matchExpressions) {
        if (this.matchExpressions != null) {
            this._visitables.get((Object)"matchExpressions").clear();
        }
        if (matchExpressions != null) {
            this.matchExpressions = new ArrayList();
            for (NodeSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        } else {
            this.matchExpressions = null;
        }
        return (A)((Object)this);
    }

    public A withMatchExpressions(NodeSelectorRequirement ... matchExpressions) {
        if (this.matchExpressions != null) {
            this.matchExpressions.clear();
            this._visitables.remove((Object)"matchExpressions");
        }
        if (matchExpressions != null) {
            for (NodeSelectorRequirement item : matchExpressions) {
                this.addToMatchExpressions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatchExpressions() {
        return this.matchExpressions != null && !this.matchExpressions.isEmpty();
    }

    public MatchExpressionsNested<A> addNewMatchExpression() {
        return new MatchExpressionsNested(-1, null);
    }

    public MatchExpressionsNested<A> addNewMatchExpressionLike(NodeSelectorRequirement item) {
        return new MatchExpressionsNested(-1, item);
    }

    public MatchExpressionsNested<A> setNewMatchExpressionLike(int index, NodeSelectorRequirement item) {
        return new MatchExpressionsNested(index, item);
    }

    public MatchExpressionsNested<A> editMatchExpression(int index) {
        if (this.matchExpressions.size() <= index) {
            throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editFirstMatchExpression() {
        if (this.matchExpressions.size() == 0) {
            throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(0, this.buildMatchExpression(0));
    }

    public MatchExpressionsNested<A> editLastMatchExpression() {
        int index = this.matchExpressions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public MatchExpressionsNested<A> editMatchingMatchExpression(Predicate<NodeSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchExpressions.size(); ++i) {
            if (!predicate.test(this.matchExpressions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
        }
        return this.setNewMatchExpressionLike(index, this.buildMatchExpression(index));
    }

    public A addToMatchFields(int index, NodeSelectorRequirement item) {
        if (this.matchFields == null) {
            this.matchFields = new ArrayList();
        }
        NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchFields.size()) {
            this._visitables.get((Object)"matchFields").add(builder);
            this.matchFields.add(builder);
        } else {
            this._visitables.get((Object)"matchFields").add(builder);
            this.matchFields.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMatchFields(int index, NodeSelectorRequirement item) {
        if (this.matchFields == null) {
            this.matchFields = new ArrayList();
        }
        NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
        if (index < 0 || index >= this.matchFields.size()) {
            this._visitables.get((Object)"matchFields").add(builder);
            this.matchFields.add(builder);
        } else {
            this._visitables.get((Object)"matchFields").add(builder);
            this.matchFields.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMatchFields(NodeSelectorRequirement ... items) {
        if (this.matchFields == null) {
            this.matchFields = new ArrayList();
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchFields").add(builder);
            this.matchFields.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMatchFields(Collection<NodeSelectorRequirement> items) {
        if (this.matchFields == null) {
            this.matchFields = new ArrayList();
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchFields").add(builder);
            this.matchFields.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMatchFields(NodeSelectorRequirement ... items) {
        if (this.matchFields == null) {
            return (A)((Object)this);
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchFields").remove((Object)builder);
            this.matchFields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMatchFields(Collection<NodeSelectorRequirement> items) {
        if (this.matchFields == null) {
            return (A)((Object)this);
        }
        for (NodeSelectorRequirement item : items) {
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            this._visitables.get((Object)"matchFields").remove((Object)builder);
            this.matchFields.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatchFields(Predicate<NodeSelectorRequirementBuilder> predicate) {
        if (this.matchFields == null) {
            return (A)((Object)this);
        }
        Iterator<NodeSelectorRequirementBuilder> each = this.matchFields.iterator();
        List visitables = this._visitables.get((Object)"matchFields");
        while (each.hasNext()) {
            NodeSelectorRequirementBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<NodeSelectorRequirement> buildMatchFields() {
        return this.matchFields != null ? NodeSelectorTermFluent.build(this.matchFields) : null;
    }

    public NodeSelectorRequirement buildMatchField(int index) {
        return this.matchFields.get(index).build();
    }

    public NodeSelectorRequirement buildFirstMatchField() {
        return this.matchFields.get(0).build();
    }

    public NodeSelectorRequirement buildLastMatchField() {
        return this.matchFields.get(this.matchFields.size() - 1).build();
    }

    public NodeSelectorRequirement buildMatchingMatchField(Predicate<NodeSelectorRequirementBuilder> predicate) {
        for (NodeSelectorRequirementBuilder item : this.matchFields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingMatchField(Predicate<NodeSelectorRequirementBuilder> predicate) {
        for (NodeSelectorRequirementBuilder item : this.matchFields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withMatchFields(List<NodeSelectorRequirement> matchFields) {
        if (this.matchFields != null) {
            this._visitables.get((Object)"matchFields").clear();
        }
        if (matchFields != null) {
            this.matchFields = new ArrayList();
            for (NodeSelectorRequirement item : matchFields) {
                this.addToMatchFields(item);
            }
        } else {
            this.matchFields = null;
        }
        return (A)((Object)this);
    }

    public A withMatchFields(NodeSelectorRequirement ... matchFields) {
        if (this.matchFields != null) {
            this.matchFields.clear();
            this._visitables.remove((Object)"matchFields");
        }
        if (matchFields != null) {
            for (NodeSelectorRequirement item : matchFields) {
                this.addToMatchFields(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasMatchFields() {
        return this.matchFields != null && !this.matchFields.isEmpty();
    }

    public MatchFieldsNested<A> addNewMatchField() {
        return new MatchFieldsNested(-1, null);
    }

    public MatchFieldsNested<A> addNewMatchFieldLike(NodeSelectorRequirement item) {
        return new MatchFieldsNested(-1, item);
    }

    public MatchFieldsNested<A> setNewMatchFieldLike(int index, NodeSelectorRequirement item) {
        return new MatchFieldsNested(index, item);
    }

    public MatchFieldsNested<A> editMatchField(int index) {
        if (this.matchFields.size() <= index) {
            throw new RuntimeException("Can't edit matchFields. Index exceeds size.");
        }
        return this.setNewMatchFieldLike(index, this.buildMatchField(index));
    }

    public MatchFieldsNested<A> editFirstMatchField() {
        if (this.matchFields.size() == 0) {
            throw new RuntimeException("Can't edit first matchFields. The list is empty.");
        }
        return this.setNewMatchFieldLike(0, this.buildMatchField(0));
    }

    public MatchFieldsNested<A> editLastMatchField() {
        int index = this.matchFields.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchFields. The list is empty.");
        }
        return this.setNewMatchFieldLike(index, this.buildMatchField(index));
    }

    public MatchFieldsNested<A> editMatchingMatchField(Predicate<NodeSelectorRequirementBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchFields.size(); ++i) {
            if (!predicate.test(this.matchFields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchFields. No match found.");
        }
        return this.setNewMatchFieldLike(index, this.buildMatchField(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NodeSelectorTermFluent that = (NodeSelectorTermFluent)((Object)o);
        if (!Objects.equals(this.matchExpressions, that.matchExpressions)) {
            return false;
        }
        if (!Objects.equals(this.matchFields, that.matchFields)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.matchExpressions, this.matchFields, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.matchExpressions != null && !this.matchExpressions.isEmpty()) {
            sb.append("matchExpressions:");
            sb.append(String.valueOf(this.matchExpressions) + ",");
        }
        if (this.matchFields != null && !this.matchFields.isEmpty()) {
            sb.append("matchFields:");
            sb.append(String.valueOf(this.matchFields) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MatchFieldsNested<N>
    extends NodeSelectorRequirementFluent<MatchFieldsNested<N>>
    implements Nested<N> {
        NodeSelectorRequirementBuilder builder;
        int index;

        MatchFieldsNested(int index, NodeSelectorRequirement item) {
            this.index = index;
            this.builder = new NodeSelectorRequirementBuilder(this, item);
        }

        public N and() {
            return (N)NodeSelectorTermFluent.this.setToMatchFields(this.index, this.builder.build());
        }

        public N endMatchField() {
            return this.and();
        }
    }

    public class MatchExpressionsNested<N>
    extends NodeSelectorRequirementFluent<MatchExpressionsNested<N>>
    implements Nested<N> {
        NodeSelectorRequirementBuilder builder;
        int index;

        MatchExpressionsNested(int index, NodeSelectorRequirement item) {
            this.index = index;
            this.builder = new NodeSelectorRequirementBuilder(this, item);
        }

        public N and() {
            return (N)NodeSelectorTermFluent.this.setToMatchExpressions(this.index, this.builder.build());
        }

        public N endMatchExpression() {
            return this.and();
        }
    }
}

