package io.fabric8.kubernetes.api.model.clusterapi.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MachineDeletionStatusFluent<A extends MachineDeletionStatusFluent<A>> extends BaseFluent<A>{
  public MachineDeletionStatusFluent() {
  }
  
  public MachineDeletionStatusFluent(MachineDeletionStatus instance) {
    this.copyInstance(instance);
  }
  private String nodeDrainStartTime;
  private String waitForNodeVolumeDetachStartTime;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MachineDeletionStatus instance) {
    instance = (instance != null ? instance : new MachineDeletionStatus());
    if (instance != null) {
          this.withNodeDrainStartTime(instance.getNodeDrainStartTime());
          this.withWaitForNodeVolumeDetachStartTime(instance.getWaitForNodeVolumeDetachStartTime());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getNodeDrainStartTime() {
    return this.nodeDrainStartTime;
  }
  
  public A withNodeDrainStartTime(String nodeDrainStartTime) {
    this.nodeDrainStartTime = nodeDrainStartTime;
    return (A) this;
  }
  
  public boolean hasNodeDrainStartTime() {
    return this.nodeDrainStartTime != null;
  }
  
  public String getWaitForNodeVolumeDetachStartTime() {
    return this.waitForNodeVolumeDetachStartTime;
  }
  
  public A withWaitForNodeVolumeDetachStartTime(String waitForNodeVolumeDetachStartTime) {
    this.waitForNodeVolumeDetachStartTime = waitForNodeVolumeDetachStartTime;
    return (A) this;
  }
  
  public boolean hasWaitForNodeVolumeDetachStartTime() {
    return this.waitForNodeVolumeDetachStartTime != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MachineDeletionStatusFluent that = (MachineDeletionStatusFluent) o;
    if (!java.util.Objects.equals(nodeDrainStartTime, that.nodeDrainStartTime)) return false;
    if (!java.util.Objects.equals(waitForNodeVolumeDetachStartTime, that.waitForNodeVolumeDetachStartTime)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(nodeDrainStartTime,  waitForNodeVolumeDetachStartTime,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (nodeDrainStartTime != null) { sb.append("nodeDrainStartTime:"); sb.append(nodeDrainStartTime + ","); }
    if (waitForNodeVolumeDetachStartTime != null) { sb.append("waitForNodeVolumeDetachStartTime:"); sb.append(waitForNodeVolumeDetachStartTime + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}