package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodConditionBuilder extends PodConditionFluent<PodConditionBuilder> implements VisitableBuilder<PodCondition,PodConditionBuilder>{
  public PodConditionBuilder() {
    this(new PodCondition());
  }
  
  public PodConditionBuilder(PodConditionFluent<?> fluent) {
    this(fluent, new PodCondition());
  }
  
  public PodConditionBuilder(PodConditionFluent<?> fluent,PodCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodConditionBuilder(PodCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodConditionFluent<?> fluent;
  
  public PodCondition build() {
    PodCondition buildable = new PodCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getObservedGeneration(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}