package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class NodeFeaturesBuilder extends NodeFeaturesFluent<NodeFeaturesBuilder> implements VisitableBuilder<NodeFeatures,NodeFeaturesBuilder>{
  public NodeFeaturesBuilder() {
    this(new NodeFeatures());
  }
  
  public NodeFeaturesBuilder(NodeFeaturesFluent<?> fluent) {
    this(fluent, new NodeFeatures());
  }
  
  public NodeFeaturesBuilder(NodeFeaturesFluent<?> fluent,NodeFeatures instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public NodeFeaturesBuilder(NodeFeatures instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  NodeFeaturesFluent<?> fluent;
  
  public NodeFeatures build() {
    NodeFeatures buildable = new NodeFeatures(fluent.getSupplementalGroupsPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}