package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ResourceRequirementsFluent<A extends ResourceRequirementsFluent<A>> extends BaseFluent<A>{
  public ResourceRequirementsFluent() {
  }
  
  public ResourceRequirementsFluent(ResourceRequirements instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ResourceClaimBuilder> claims = new ArrayList<ResourceClaimBuilder>();
  private Map<String,Quantity> limits;
  private Map<String,Quantity> requests;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ResourceRequirements instance) {
    instance = (instance != null ? instance : new ResourceRequirements());
    if (instance != null) {
          this.withClaims(instance.getClaims());
          this.withLimits(instance.getLimits());
          this.withRequests(instance.getRequests());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToClaims(int index,ResourceClaim item) {
    if (this.claims == null) {this.claims = new ArrayList<ResourceClaimBuilder>();}
    ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
    if (index < 0 || index >= claims.size()) { _visitables.get("claims").add(builder); claims.add(builder); } else { _visitables.get("claims").add(index, builder); claims.add(index, builder);}
    return (A)this;
  }
  
  public A setToClaims(int index,ResourceClaim item) {
    if (this.claims == null) {this.claims = new ArrayList<ResourceClaimBuilder>();}
    ResourceClaimBuilder builder = new ResourceClaimBuilder(item);
    if (index < 0 || index >= claims.size()) { _visitables.get("claims").add(builder); claims.add(builder); } else { _visitables.get("claims").set(index, builder); claims.set(index, builder);}
    return (A)this;
  }
  
  public A addToClaims(io.fabric8.kubernetes.api.model.ResourceClaim... items) {
    if (this.claims == null) {this.claims = new ArrayList<ResourceClaimBuilder>();}
    for (ResourceClaim item : items) {ResourceClaimBuilder builder = new ResourceClaimBuilder(item);_visitables.get("claims").add(builder);this.claims.add(builder);} return (A)this;
  }
  
  public A addAllToClaims(Collection<ResourceClaim> items) {
    if (this.claims == null) {this.claims = new ArrayList<ResourceClaimBuilder>();}
    for (ResourceClaim item : items) {ResourceClaimBuilder builder = new ResourceClaimBuilder(item);_visitables.get("claims").add(builder);this.claims.add(builder);} return (A)this;
  }
  
  public A removeFromClaims(io.fabric8.kubernetes.api.model.ResourceClaim... items) {
    if (this.claims == null) return (A)this;
    for (ResourceClaim item : items) {ResourceClaimBuilder builder = new ResourceClaimBuilder(item);_visitables.get("claims").remove(builder); this.claims.remove(builder);} return (A)this;
  }
  
  public A removeAllFromClaims(Collection<ResourceClaim> items) {
    if (this.claims == null) return (A)this;
    for (ResourceClaim item : items) {ResourceClaimBuilder builder = new ResourceClaimBuilder(item);_visitables.get("claims").remove(builder); this.claims.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromClaims(Predicate<ResourceClaimBuilder> predicate) {
    if (claims == null) return (A) this;
    final Iterator<ResourceClaimBuilder> each = claims.iterator();
    final List visitables = _visitables.get("claims");
    while (each.hasNext()) {
      ResourceClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ResourceClaim> buildClaims() {
    return this.claims != null ? build(claims) : null;
  }
  
  public ResourceClaim buildClaim(int index) {
    return this.claims.get(index).build();
  }
  
  public ResourceClaim buildFirstClaim() {
    return this.claims.get(0).build();
  }
  
  public ResourceClaim buildLastClaim() {
    return this.claims.get(claims.size() - 1).build();
  }
  
  public ResourceClaim buildMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
      for (ResourceClaimBuilder item : claims) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
      for (ResourceClaimBuilder item : claims) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withClaims(List<ResourceClaim> claims) {
    if (this.claims != null) {
      this._visitables.get("claims").clear();
    }
    if (claims != null) {
        this.claims = new ArrayList();
        for (ResourceClaim item : claims) {
          this.addToClaims(item);
        }
    } else {
      this.claims = null;
    }
    return (A) this;
  }
  
  public A withClaims(io.fabric8.kubernetes.api.model.ResourceClaim... claims) {
    if (this.claims != null) {
        this.claims.clear();
        _visitables.remove("claims");
    }
    if (claims != null) {
      for (ResourceClaim item : claims) {
        this.addToClaims(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasClaims() {
    return this.claims != null && !this.claims.isEmpty();
  }
  
  public A addNewClaim(String name,String request) {
    return (A)addToClaims(new ResourceClaim(name, request));
  }
  
  public ClaimsNested<A> addNewClaim() {
    return new ClaimsNested(-1, null);
  }
  
  public ClaimsNested<A> addNewClaimLike(ResourceClaim item) {
    return new ClaimsNested(-1, item);
  }
  
  public ClaimsNested<A> setNewClaimLike(int index,ResourceClaim item) {
    return new ClaimsNested(index, item);
  }
  
  public ClaimsNested<A> editClaim(int index) {
    if (claims.size() <= index) throw new RuntimeException("Can't edit claims. Index exceeds size.");
    return setNewClaimLike(index, buildClaim(index));
  }
  
  public ClaimsNested<A> editFirstClaim() {
    if (claims.size() == 0) throw new RuntimeException("Can't edit first claims. The list is empty.");
    return setNewClaimLike(0, buildClaim(0));
  }
  
  public ClaimsNested<A> editLastClaim() {
    int index = claims.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last claims. The list is empty.");
    return setNewClaimLike(index, buildClaim(index));
  }
  
  public ClaimsNested<A> editMatchingClaim(Predicate<ResourceClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<claims.size();i++) { 
    if (predicate.test(claims.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching claims. No match found.");
    return setNewClaimLike(index, buildClaim(index));
  }
  
  public A addToLimits(String key,Quantity value) {
    if(this.limits == null && key != null && value != null) { this.limits = new LinkedHashMap(); }
    if(key != null && value != null) {this.limits.put(key, value);} return (A)this;
  }
  
  public A addToLimits(Map<String,Quantity> map) {
    if(this.limits == null && map != null) { this.limits = new LinkedHashMap(); }
    if(map != null) { this.limits.putAll(map);} return (A)this;
  }
  
  public A removeFromLimits(String key) {
    if(this.limits == null) { return (A) this; }
    if(key != null && this.limits != null) {this.limits.remove(key);} return (A)this;
  }
  
  public A removeFromLimits(Map<String,Quantity> map) {
    if(this.limits == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.limits != null){this.limits.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getLimits() {
    return this.limits;
  }
  
  public <K,V>A withLimits(Map<String,Quantity> limits) {
    if (limits == null) {
      this.limits = null;
    } else {
      this.limits = new LinkedHashMap(limits);
    }
    return (A) this;
  }
  
  public boolean hasLimits() {
    return this.limits != null;
  }
  
  public A addToRequests(String key,Quantity value) {
    if(this.requests == null && key != null && value != null) { this.requests = new LinkedHashMap(); }
    if(key != null && value != null) {this.requests.put(key, value);} return (A)this;
  }
  
  public A addToRequests(Map<String,Quantity> map) {
    if(this.requests == null && map != null) { this.requests = new LinkedHashMap(); }
    if(map != null) { this.requests.putAll(map);} return (A)this;
  }
  
  public A removeFromRequests(String key) {
    if(this.requests == null) { return (A) this; }
    if(key != null && this.requests != null) {this.requests.remove(key);} return (A)this;
  }
  
  public A removeFromRequests(Map<String,Quantity> map) {
    if(this.requests == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.requests != null){this.requests.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getRequests() {
    return this.requests;
  }
  
  public <K,V>A withRequests(Map<String,Quantity> requests) {
    if (requests == null) {
      this.requests = null;
    } else {
      this.requests = new LinkedHashMap(requests);
    }
    return (A) this;
  }
  
  public boolean hasRequests() {
    return this.requests != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ResourceRequirementsFluent that = (ResourceRequirementsFluent) o;
    if (!java.util.Objects.equals(claims, that.claims)) return false;
    if (!java.util.Objects.equals(limits, that.limits)) return false;
    if (!java.util.Objects.equals(requests, that.requests)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(claims,  limits,  requests,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (claims != null && !claims.isEmpty()) { sb.append("claims:"); sb.append(claims + ","); }
    if (limits != null && !limits.isEmpty()) { sb.append("limits:"); sb.append(limits + ","); }
    if (requests != null && !requests.isEmpty()) { sb.append("requests:"); sb.append(requests + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ClaimsNested<N> extends ResourceClaimFluent<ClaimsNested<N>> implements Nested<N>{
    ClaimsNested(int index,ResourceClaim item) {
      this.index = index;
      this.builder = new ResourceClaimBuilder(this, item);
    }
    ResourceClaimBuilder builder;
    int index;
    
    public N and() {
      return (N) ResourceRequirementsFluent.this.setToClaims(index,builder.build());
    }
    
    public N endClaim() {
      return and();
    }
    
  
  }

}