package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class DeleteOptionsBuilder extends DeleteOptionsFluent<DeleteOptionsBuilder> implements VisitableBuilder<DeleteOptions,DeleteOptionsBuilder>{
  public DeleteOptionsBuilder() {
    this(new DeleteOptions());
  }
  
  public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent) {
    this(fluent, new DeleteOptions());
  }
  
  public DeleteOptionsBuilder(DeleteOptionsFluent<?> fluent,DeleteOptions instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public DeleteOptionsBuilder(DeleteOptions instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  DeleteOptionsFluent<?> fluent;
  
  public DeleteOptions build() {
    DeleteOptions buildable = new DeleteOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getGracePeriodSeconds(),fluent.getIgnoreStoreReadErrorWithClusterBreakingPotential(),fluent.getKind(),fluent.getOrphanDependents(),fluent.buildPreconditions(),fluent.getPropagationPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}