package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContextFluent<A extends ContextFluent<A>> extends BaseFluent<A>{
  public ContextFluent() {
  }
  
  public ContextFluent(Context instance) {
    this.copyInstance(instance);
  }
  private String cluster;
  private ArrayList<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();
  private String namespace;
  private String user;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(Context instance) {
    instance = (instance != null ? instance : new Context());
    if (instance != null) {
          this.withCluster(instance.getCluster());
          this.withExtensions(instance.getExtensions());
          this.withNamespace(instance.getNamespace());
          this.withUser(instance.getUser());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCluster() {
    return this.cluster;
  }
  
  public A withCluster(String cluster) {
    this.cluster = cluster;
    return (A) this;
  }
  
  public boolean hasCluster() {
    return this.cluster != null;
  }
  
  public A addToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) { _visitables.get("extensions").add(builder); extensions.add(builder); } else { _visitables.get("extensions").add(index, builder); extensions.add(index, builder);}
    return (A)this;
  }
  
  public A setToExtensions(int index,NamedExtension item) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
    if (index < 0 || index >= extensions.size()) { _visitables.get("extensions").add(builder); extensions.add(builder); } else { _visitables.get("extensions").set(index, builder); extensions.set(index, builder);}
    return (A)this;
  }
  
  public A addToExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  
  public A addAllToExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) {this.extensions = new ArrayList<NamedExtensionBuilder>();}
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").add(builder);this.extensions.add(builder);} return (A)this;
  }
  
  public A removeFromExtensions(io.fabric8.kubernetes.api.model.NamedExtension... items) {
    if (this.extensions == null) return (A)this;
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder); this.extensions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExtensions(Collection<NamedExtension> items) {
    if (this.extensions == null) return (A)this;
    for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.get("extensions").remove(builder); this.extensions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExtensions(Predicate<NamedExtensionBuilder> predicate) {
    if (extensions == null) return (A) this;
    final Iterator<NamedExtensionBuilder> each = extensions.iterator();
    final List visitables = _visitables.get("extensions");
    while (each.hasNext()) {
      NamedExtensionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedExtension> buildExtensions() {
    return this.extensions != null ? build(extensions) : null;
  }
  
  public NamedExtension buildExtension(int index) {
    return this.extensions.get(index).build();
  }
  
  public NamedExtension buildFirstExtension() {
    return this.extensions.get(0).build();
  }
  
  public NamedExtension buildLastExtension() {
    return this.extensions.get(extensions.size() - 1).build();
  }
  
  public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
      for (NamedExtensionBuilder item : extensions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
      for (NamedExtensionBuilder item : extensions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExtensions(List<NamedExtension> extensions) {
    if (this.extensions != null) {
      this._visitables.get("extensions").clear();
    }
    if (extensions != null) {
        this.extensions = new ArrayList();
        for (NamedExtension item : extensions) {
          this.addToExtensions(item);
        }
    } else {
      this.extensions = null;
    }
    return (A) this;
  }
  
  public A withExtensions(io.fabric8.kubernetes.api.model.NamedExtension... extensions) {
    if (this.extensions != null) {
        this.extensions.clear();
        _visitables.remove("extensions");
    }
    if (extensions != null) {
      for (NamedExtension item : extensions) {
        this.addToExtensions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExtensions() {
    return this.extensions != null && !this.extensions.isEmpty();
  }
  
  public A addNewExtension(Object extension,String name) {
    return (A)addToExtensions(new NamedExtension(extension, name));
  }
  
  public ExtensionsNested<A> addNewExtension() {
    return new ExtensionsNested(-1, null);
  }
  
  public ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
    return new ExtensionsNested(-1, item);
  }
  
  public ExtensionsNested<A> setNewExtensionLike(int index,NamedExtension item) {
    return new ExtensionsNested(index, item);
  }
  
  public ExtensionsNested<A> editExtension(int index) {
    if (extensions.size() <= index) throw new RuntimeException("Can't edit extensions. Index exceeds size.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public ExtensionsNested<A> editFirstExtension() {
    if (extensions.size() == 0) throw new RuntimeException("Can't edit first extensions. The list is empty.");
    return setNewExtensionLike(0, buildExtension(0));
  }
  
  public ExtensionsNested<A> editLastExtension() {
    int index = extensions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last extensions. The list is empty.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<extensions.size();i++) { 
    if (predicate.test(extensions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching extensions. No match found.");
    return setNewExtensionLike(index, buildExtension(index));
  }
  
  public String getNamespace() {
    return this.namespace;
  }
  
  public A withNamespace(String namespace) {
    this.namespace = namespace;
    return (A) this;
  }
  
  public boolean hasNamespace() {
    return this.namespace != null;
  }
  
  public String getUser() {
    return this.user;
  }
  
  public A withUser(String user) {
    this.user = user;
    return (A) this;
  }
  
  public boolean hasUser() {
    return this.user != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContextFluent that = (ContextFluent) o;
    if (!java.util.Objects.equals(cluster, that.cluster)) return false;
    if (!java.util.Objects.equals(extensions, that.extensions)) return false;
    if (!java.util.Objects.equals(namespace, that.namespace)) return false;
    if (!java.util.Objects.equals(user, that.user)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(cluster,  extensions,  namespace,  user,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (cluster != null) { sb.append("cluster:"); sb.append(cluster + ","); }
    if (extensions != null && !extensions.isEmpty()) { sb.append("extensions:"); sb.append(extensions + ","); }
    if (namespace != null) { sb.append("namespace:"); sb.append(namespace + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ExtensionsNested<N> extends NamedExtensionFluent<ExtensionsNested<N>> implements Nested<N>{
    ExtensionsNested(int index,NamedExtension item) {
      this.index = index;
      this.builder = new NamedExtensionBuilder(this, item);
    }
    NamedExtensionBuilder builder;
    int index;
    
    public N and() {
      return (N) ContextFluent.this.setToExtensions(index,builder.build());
    }
    
    public N endExtension() {
      return and();
    }
    
  
  }

}