package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ContainerStatusFluent<A extends ContainerStatusFluent<A>> extends BaseFluent<A>{
  public ContainerStatusFluent() {
  }
  
  public ContainerStatusFluent(ContainerStatus instance) {
    this.copyInstance(instance);
  }
  private Map<String,Quantity> allocatedResources;
  private ArrayList<ResourceStatusBuilder> allocatedResourcesStatus = new ArrayList<ResourceStatusBuilder>();
  private String containerID;
  private String image;
  private String imageID;
  private ContainerStateBuilder lastState;
  private String name;
  private Boolean ready;
  private ResourceRequirementsBuilder resources;
  private Integer restartCount;
  private Boolean started;
  private ContainerStateBuilder state;
  private ContainerUserBuilder user;
  private ArrayList<VolumeMountStatusBuilder> volumeMounts = new ArrayList<VolumeMountStatusBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ContainerStatus instance) {
    instance = (instance != null ? instance : new ContainerStatus());
    if (instance != null) {
          this.withAllocatedResources(instance.getAllocatedResources());
          this.withAllocatedResourcesStatus(instance.getAllocatedResourcesStatus());
          this.withContainerID(instance.getContainerID());
          this.withImage(instance.getImage());
          this.withImageID(instance.getImageID());
          this.withLastState(instance.getLastState());
          this.withName(instance.getName());
          this.withReady(instance.getReady());
          this.withResources(instance.getResources());
          this.withRestartCount(instance.getRestartCount());
          this.withStarted(instance.getStarted());
          this.withState(instance.getState());
          this.withUser(instance.getUser());
          this.withVolumeMounts(instance.getVolumeMounts());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAllocatedResources(String key,Quantity value) {
    if(this.allocatedResources == null && key != null && value != null) { this.allocatedResources = new LinkedHashMap(); }
    if(key != null && value != null) {this.allocatedResources.put(key, value);} return (A)this;
  }
  
  public A addToAllocatedResources(Map<String,Quantity> map) {
    if(this.allocatedResources == null && map != null) { this.allocatedResources = new LinkedHashMap(); }
    if(map != null) { this.allocatedResources.putAll(map);} return (A)this;
  }
  
  public A removeFromAllocatedResources(String key) {
    if(this.allocatedResources == null) { return (A) this; }
    if(key != null && this.allocatedResources != null) {this.allocatedResources.remove(key);} return (A)this;
  }
  
  public A removeFromAllocatedResources(Map<String,Quantity> map) {
    if(this.allocatedResources == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocatedResources != null){this.allocatedResources.remove(key);}}} return (A)this;
  }
  
  public Map<String,Quantity> getAllocatedResources() {
    return this.allocatedResources;
  }
  
  public <K,V>A withAllocatedResources(Map<String,Quantity> allocatedResources) {
    if (allocatedResources == null) {
      this.allocatedResources = null;
    } else {
      this.allocatedResources = new LinkedHashMap(allocatedResources);
    }
    return (A) this;
  }
  
  public boolean hasAllocatedResources() {
    return this.allocatedResources != null;
  }
  
  public A addToAllocatedResourcesStatus(int index,ResourceStatus item) {
    if (this.allocatedResourcesStatus == null) {this.allocatedResourcesStatus = new ArrayList<ResourceStatusBuilder>();}
    ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
    if (index < 0 || index >= allocatedResourcesStatus.size()) { _visitables.get("allocatedResourcesStatus").add(builder); allocatedResourcesStatus.add(builder); } else { _visitables.get("allocatedResourcesStatus").add(index, builder); allocatedResourcesStatus.add(index, builder);}
    return (A)this;
  }
  
  public A setToAllocatedResourcesStatus(int index,ResourceStatus item) {
    if (this.allocatedResourcesStatus == null) {this.allocatedResourcesStatus = new ArrayList<ResourceStatusBuilder>();}
    ResourceStatusBuilder builder = new ResourceStatusBuilder(item);
    if (index < 0 || index >= allocatedResourcesStatus.size()) { _visitables.get("allocatedResourcesStatus").add(builder); allocatedResourcesStatus.add(builder); } else { _visitables.get("allocatedResourcesStatus").set(index, builder); allocatedResourcesStatus.set(index, builder);}
    return (A)this;
  }
  
  public A addToAllocatedResourcesStatus(io.fabric8.kubernetes.api.model.ResourceStatus... items) {
    if (this.allocatedResourcesStatus == null) {this.allocatedResourcesStatus = new ArrayList<ResourceStatusBuilder>();}
    for (ResourceStatus item : items) {ResourceStatusBuilder builder = new ResourceStatusBuilder(item);_visitables.get("allocatedResourcesStatus").add(builder);this.allocatedResourcesStatus.add(builder);} return (A)this;
  }
  
  public A addAllToAllocatedResourcesStatus(Collection<ResourceStatus> items) {
    if (this.allocatedResourcesStatus == null) {this.allocatedResourcesStatus = new ArrayList<ResourceStatusBuilder>();}
    for (ResourceStatus item : items) {ResourceStatusBuilder builder = new ResourceStatusBuilder(item);_visitables.get("allocatedResourcesStatus").add(builder);this.allocatedResourcesStatus.add(builder);} return (A)this;
  }
  
  public A removeFromAllocatedResourcesStatus(io.fabric8.kubernetes.api.model.ResourceStatus... items) {
    if (this.allocatedResourcesStatus == null) return (A)this;
    for (ResourceStatus item : items) {ResourceStatusBuilder builder = new ResourceStatusBuilder(item);_visitables.get("allocatedResourcesStatus").remove(builder); this.allocatedResourcesStatus.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAllocatedResourcesStatus(Collection<ResourceStatus> items) {
    if (this.allocatedResourcesStatus == null) return (A)this;
    for (ResourceStatus item : items) {ResourceStatusBuilder builder = new ResourceStatusBuilder(item);_visitables.get("allocatedResourcesStatus").remove(builder); this.allocatedResourcesStatus.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
    if (allocatedResourcesStatus == null) return (A) this;
    final Iterator<ResourceStatusBuilder> each = allocatedResourcesStatus.iterator();
    final List visitables = _visitables.get("allocatedResourcesStatus");
    while (each.hasNext()) {
      ResourceStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ResourceStatus> buildAllocatedResourcesStatus() {
    return this.allocatedResourcesStatus != null ? build(allocatedResourcesStatus) : null;
  }
  
  public ResourceStatus buildAllocatedResourcesStatus(int index) {
    return this.allocatedResourcesStatus.get(index).build();
  }
  
  public ResourceStatus buildFirstAllocatedResourcesStatus() {
    return this.allocatedResourcesStatus.get(0).build();
  }
  
  public ResourceStatus buildLastAllocatedResourcesStatus() {
    return this.allocatedResourcesStatus.get(allocatedResourcesStatus.size() - 1).build();
  }
  
  public ResourceStatus buildMatchingAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
      for (ResourceStatusBuilder item : allocatedResourcesStatus) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
      for (ResourceStatusBuilder item : allocatedResourcesStatus) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAllocatedResourcesStatus(List<ResourceStatus> allocatedResourcesStatus) {
    if (this.allocatedResourcesStatus != null) {
      this._visitables.get("allocatedResourcesStatus").clear();
    }
    if (allocatedResourcesStatus != null) {
        this.allocatedResourcesStatus = new ArrayList();
        for (ResourceStatus item : allocatedResourcesStatus) {
          this.addToAllocatedResourcesStatus(item);
        }
    } else {
      this.allocatedResourcesStatus = null;
    }
    return (A) this;
  }
  
  public A withAllocatedResourcesStatus(io.fabric8.kubernetes.api.model.ResourceStatus... allocatedResourcesStatus) {
    if (this.allocatedResourcesStatus != null) {
        this.allocatedResourcesStatus.clear();
        _visitables.remove("allocatedResourcesStatus");
    }
    if (allocatedResourcesStatus != null) {
      for (ResourceStatus item : allocatedResourcesStatus) {
        this.addToAllocatedResourcesStatus(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAllocatedResourcesStatus() {
    return this.allocatedResourcesStatus != null && !this.allocatedResourcesStatus.isEmpty();
  }
  
  public AllocatedResourcesStatusNested<A> addNewAllocatedResourcesStatus() {
    return new AllocatedResourcesStatusNested(-1, null);
  }
  
  public AllocatedResourcesStatusNested<A> addNewAllocatedResourcesStatusLike(ResourceStatus item) {
    return new AllocatedResourcesStatusNested(-1, item);
  }
  
  public AllocatedResourcesStatusNested<A> setNewAllocatedResourcesStatusLike(int index,ResourceStatus item) {
    return new AllocatedResourcesStatusNested(index, item);
  }
  
  public AllocatedResourcesStatusNested<A> editAllocatedResourcesStatus(int index) {
    if (allocatedResourcesStatus.size() <= index) throw new RuntimeException("Can't edit allocatedResourcesStatus. Index exceeds size.");
    return setNewAllocatedResourcesStatusLike(index, buildAllocatedResourcesStatus(index));
  }
  
  public AllocatedResourcesStatusNested<A> editFirstAllocatedResourcesStatus() {
    if (allocatedResourcesStatus.size() == 0) throw new RuntimeException("Can't edit first allocatedResourcesStatus. The list is empty.");
    return setNewAllocatedResourcesStatusLike(0, buildAllocatedResourcesStatus(0));
  }
  
  public AllocatedResourcesStatusNested<A> editLastAllocatedResourcesStatus() {
    int index = allocatedResourcesStatus.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allocatedResourcesStatus. The list is empty.");
    return setNewAllocatedResourcesStatusLike(index, buildAllocatedResourcesStatus(index));
  }
  
  public AllocatedResourcesStatusNested<A> editMatchingAllocatedResourcesStatus(Predicate<ResourceStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allocatedResourcesStatus.size();i++) { 
    if (predicate.test(allocatedResourcesStatus.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allocatedResourcesStatus. No match found.");
    return setNewAllocatedResourcesStatusLike(index, buildAllocatedResourcesStatus(index));
  }
  
  public String getContainerID() {
    return this.containerID;
  }
  
  public A withContainerID(String containerID) {
    this.containerID = containerID;
    return (A) this;
  }
  
  public boolean hasContainerID() {
    return this.containerID != null;
  }
  
  public String getImage() {
    return this.image;
  }
  
  public A withImage(String image) {
    this.image = image;
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public String getImageID() {
    return this.imageID;
  }
  
  public A withImageID(String imageID) {
    this.imageID = imageID;
    return (A) this;
  }
  
  public boolean hasImageID() {
    return this.imageID != null;
  }
  
  public ContainerState buildLastState() {
    return this.lastState != null ? this.lastState.build() : null;
  }
  
  public A withLastState(ContainerState lastState) {
    this._visitables.remove("lastState");
    if (lastState != null) {
        this.lastState = new ContainerStateBuilder(lastState);
        this._visitables.get("lastState").add(this.lastState);
    } else {
        this.lastState = null;
        this._visitables.get("lastState").remove(this.lastState);
    }
    return (A) this;
  }
  
  public boolean hasLastState() {
    return this.lastState != null;
  }
  
  public LastStateNested<A> withNewLastState() {
    return new LastStateNested(null);
  }
  
  public LastStateNested<A> withNewLastStateLike(ContainerState item) {
    return new LastStateNested(item);
  }
  
  public LastStateNested<A> editLastState() {
    return withNewLastStateLike(java.util.Optional.ofNullable(buildLastState()).orElse(null));
  }
  
  public LastStateNested<A> editOrNewLastState() {
    return withNewLastStateLike(java.util.Optional.ofNullable(buildLastState()).orElse(new ContainerStateBuilder().build()));
  }
  
  public LastStateNested<A> editOrNewLastStateLike(ContainerState item) {
    return withNewLastStateLike(java.util.Optional.ofNullable(buildLastState()).orElse(item));
  }
  
  public String getName() {
    return this.name;
  }
  
  public A withName(String name) {
    this.name = name;
    return (A) this;
  }
  
  public boolean hasName() {
    return this.name != null;
  }
  
  public Boolean getReady() {
    return this.ready;
  }
  
  public A withReady(Boolean ready) {
    this.ready = ready;
    return (A) this;
  }
  
  public boolean hasReady() {
    return this.ready != null;
  }
  
  public ResourceRequirements buildResources() {
    return this.resources != null ? this.resources.build() : null;
  }
  
  public A withResources(ResourceRequirements resources) {
    this._visitables.remove("resources");
    if (resources != null) {
        this.resources = new ResourceRequirementsBuilder(resources);
        this._visitables.get("resources").add(this.resources);
    } else {
        this.resources = null;
        this._visitables.get("resources").remove(this.resources);
    }
    return (A) this;
  }
  
  public boolean hasResources() {
    return this.resources != null;
  }
  
  public ResourcesNested<A> withNewResources() {
    return new ResourcesNested(null);
  }
  
  public ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
    return new ResourcesNested(item);
  }
  
  public ResourcesNested<A> editResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(null));
  }
  
  public ResourcesNested<A> editOrNewResources() {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
    return withNewResourcesLike(java.util.Optional.ofNullable(buildResources()).orElse(item));
  }
  
  public Integer getRestartCount() {
    return this.restartCount;
  }
  
  public A withRestartCount(Integer restartCount) {
    this.restartCount = restartCount;
    return (A) this;
  }
  
  public boolean hasRestartCount() {
    return this.restartCount != null;
  }
  
  public Boolean getStarted() {
    return this.started;
  }
  
  public A withStarted(Boolean started) {
    this.started = started;
    return (A) this;
  }
  
  public boolean hasStarted() {
    return this.started != null;
  }
  
  public ContainerState buildState() {
    return this.state != null ? this.state.build() : null;
  }
  
  public A withState(ContainerState state) {
    this._visitables.remove("state");
    if (state != null) {
        this.state = new ContainerStateBuilder(state);
        this._visitables.get("state").add(this.state);
    } else {
        this.state = null;
        this._visitables.get("state").remove(this.state);
    }
    return (A) this;
  }
  
  public boolean hasState() {
    return this.state != null;
  }
  
  public StateNested<A> withNewState() {
    return new StateNested(null);
  }
  
  public StateNested<A> withNewStateLike(ContainerState item) {
    return new StateNested(item);
  }
  
  public StateNested<A> editState() {
    return withNewStateLike(java.util.Optional.ofNullable(buildState()).orElse(null));
  }
  
  public StateNested<A> editOrNewState() {
    return withNewStateLike(java.util.Optional.ofNullable(buildState()).orElse(new ContainerStateBuilder().build()));
  }
  
  public StateNested<A> editOrNewStateLike(ContainerState item) {
    return withNewStateLike(java.util.Optional.ofNullable(buildState()).orElse(item));
  }
  
  public ContainerUser buildUser() {
    return this.user != null ? this.user.build() : null;
  }
  
  public A withUser(ContainerUser user) {
    this._visitables.remove("user");
    if (user != null) {
        this.user = new ContainerUserBuilder(user);
        this._visitables.get("user").add(this.user);
    } else {
        this.user = null;
        this._visitables.get("user").remove(this.user);
    }
    return (A) this;
  }
  
  public boolean hasUser() {
    return this.user != null;
  }
  
  public UserNested<A> withNewUser() {
    return new UserNested(null);
  }
  
  public UserNested<A> withNewUserLike(ContainerUser item) {
    return new UserNested(item);
  }
  
  public UserNested<A> editUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(null));
  }
  
  public UserNested<A> editOrNewUser() {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(new ContainerUserBuilder().build()));
  }
  
  public UserNested<A> editOrNewUserLike(ContainerUser item) {
    return withNewUserLike(java.util.Optional.ofNullable(buildUser()).orElse(item));
  }
  
  public A addToVolumeMounts(int index,VolumeMountStatus item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountStatusBuilder>();}
    VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) { _visitables.get("volumeMounts").add(builder); volumeMounts.add(builder); } else { _visitables.get("volumeMounts").add(index, builder); volumeMounts.add(index, builder);}
    return (A)this;
  }
  
  public A setToVolumeMounts(int index,VolumeMountStatus item) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountStatusBuilder>();}
    VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);
    if (index < 0 || index >= volumeMounts.size()) { _visitables.get("volumeMounts").add(builder); volumeMounts.add(builder); } else { _visitables.get("volumeMounts").set(index, builder); volumeMounts.set(index, builder);}
    return (A)this;
  }
  
  public A addToVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMountStatus... items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountStatusBuilder>();}
    for (VolumeMountStatus item : items) {VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  
  public A addAllToVolumeMounts(Collection<VolumeMountStatus> items) {
    if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountStatusBuilder>();}
    for (VolumeMountStatus item : items) {VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
  }
  
  public A removeFromVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMountStatus... items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMountStatus item : items) {VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);_visitables.get("volumeMounts").remove(builder); this.volumeMounts.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumeMounts(Collection<VolumeMountStatus> items) {
    if (this.volumeMounts == null) return (A)this;
    for (VolumeMountStatus item : items) {VolumeMountStatusBuilder builder = new VolumeMountStatusBuilder(item);_visitables.get("volumeMounts").remove(builder); this.volumeMounts.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumeMounts(Predicate<VolumeMountStatusBuilder> predicate) {
    if (volumeMounts == null) return (A) this;
    final Iterator<VolumeMountStatusBuilder> each = volumeMounts.iterator();
    final List visitables = _visitables.get("volumeMounts");
    while (each.hasNext()) {
      VolumeMountStatusBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<VolumeMountStatus> buildVolumeMounts() {
    return this.volumeMounts != null ? build(volumeMounts) : null;
  }
  
  public VolumeMountStatus buildVolumeMount(int index) {
    return this.volumeMounts.get(index).build();
  }
  
  public VolumeMountStatus buildFirstVolumeMount() {
    return this.volumeMounts.get(0).build();
  }
  
  public VolumeMountStatus buildLastVolumeMount() {
    return this.volumeMounts.get(volumeMounts.size() - 1).build();
  }
  
  public VolumeMountStatus buildMatchingVolumeMount(Predicate<VolumeMountStatusBuilder> predicate) {
      for (VolumeMountStatusBuilder item : volumeMounts) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumeMount(Predicate<VolumeMountStatusBuilder> predicate) {
      for (VolumeMountStatusBuilder item : volumeMounts) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumeMounts(List<VolumeMountStatus> volumeMounts) {
    if (this.volumeMounts != null) {
      this._visitables.get("volumeMounts").clear();
    }
    if (volumeMounts != null) {
        this.volumeMounts = new ArrayList();
        for (VolumeMountStatus item : volumeMounts) {
          this.addToVolumeMounts(item);
        }
    } else {
      this.volumeMounts = null;
    }
    return (A) this;
  }
  
  public A withVolumeMounts(io.fabric8.kubernetes.api.model.VolumeMountStatus... volumeMounts) {
    if (this.volumeMounts != null) {
        this.volumeMounts.clear();
        _visitables.remove("volumeMounts");
    }
    if (volumeMounts != null) {
      for (VolumeMountStatus item : volumeMounts) {
        this.addToVolumeMounts(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVolumeMounts() {
    return this.volumeMounts != null && !this.volumeMounts.isEmpty();
  }
  
  public A addNewVolumeMount(String mountPath,String name,Boolean readOnly,String recursiveReadOnly) {
    return (A)addToVolumeMounts(new VolumeMountStatus(mountPath, name, readOnly, recursiveReadOnly));
  }
  
  public VolumeMountsNested<A> addNewVolumeMount() {
    return new VolumeMountsNested(-1, null);
  }
  
  public VolumeMountsNested<A> addNewVolumeMountLike(VolumeMountStatus item) {
    return new VolumeMountsNested(-1, item);
  }
  
  public VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMountStatus item) {
    return new VolumeMountsNested(index, item);
  }
  
  public VolumeMountsNested<A> editVolumeMount(int index) {
    if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public VolumeMountsNested<A> editFirstVolumeMount() {
    if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
    return setNewVolumeMountLike(0, buildVolumeMount(0));
  }
  
  public VolumeMountsNested<A> editLastVolumeMount() {
    int index = volumeMounts.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountStatusBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeMounts.size();i++) { 
    if (predicate.test(volumeMounts.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
    return setNewVolumeMountLike(index, buildVolumeMount(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ContainerStatusFluent that = (ContainerStatusFluent) o;
    if (!java.util.Objects.equals(allocatedResources, that.allocatedResources)) return false;
    if (!java.util.Objects.equals(allocatedResourcesStatus, that.allocatedResourcesStatus)) return false;
    if (!java.util.Objects.equals(containerID, that.containerID)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(imageID, that.imageID)) return false;
    if (!java.util.Objects.equals(lastState, that.lastState)) return false;
    if (!java.util.Objects.equals(name, that.name)) return false;
    if (!java.util.Objects.equals(ready, that.ready)) return false;
    if (!java.util.Objects.equals(resources, that.resources)) return false;
    if (!java.util.Objects.equals(restartCount, that.restartCount)) return false;
    if (!java.util.Objects.equals(started, that.started)) return false;
    if (!java.util.Objects.equals(state, that.state)) return false;
    if (!java.util.Objects.equals(user, that.user)) return false;
    if (!java.util.Objects.equals(volumeMounts, that.volumeMounts)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(allocatedResources,  allocatedResourcesStatus,  containerID,  image,  imageID,  lastState,  name,  ready,  resources,  restartCount,  started,  state,  user,  volumeMounts,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocatedResources != null && !allocatedResources.isEmpty()) { sb.append("allocatedResources:"); sb.append(allocatedResources + ","); }
    if (allocatedResourcesStatus != null && !allocatedResourcesStatus.isEmpty()) { sb.append("allocatedResourcesStatus:"); sb.append(allocatedResourcesStatus + ","); }
    if (containerID != null) { sb.append("containerID:"); sb.append(containerID + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (imageID != null) { sb.append("imageID:"); sb.append(imageID + ","); }
    if (lastState != null) { sb.append("lastState:"); sb.append(lastState + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (ready != null) { sb.append("ready:"); sb.append(ready + ","); }
    if (resources != null) { sb.append("resources:"); sb.append(resources + ","); }
    if (restartCount != null) { sb.append("restartCount:"); sb.append(restartCount + ","); }
    if (started != null) { sb.append("started:"); sb.append(started + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (user != null) { sb.append("user:"); sb.append(user + ","); }
    if (volumeMounts != null && !volumeMounts.isEmpty()) { sb.append("volumeMounts:"); sb.append(volumeMounts + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withReady() {
    return withReady(true);
  }
  
  public A withStarted() {
    return withStarted(true);
  }
  public class AllocatedResourcesStatusNested<N> extends ResourceStatusFluent<AllocatedResourcesStatusNested<N>> implements Nested<N>{
    AllocatedResourcesStatusNested(int index,ResourceStatus item) {
      this.index = index;
      this.builder = new ResourceStatusBuilder(this, item);
    }
    ResourceStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ContainerStatusFluent.this.setToAllocatedResourcesStatus(index,builder.build());
    }
    
    public N endAllocatedResourcesStatus() {
      return and();
    }
    
  
  }
  public class LastStateNested<N> extends ContainerStateFluent<LastStateNested<N>> implements Nested<N>{
    LastStateNested(ContainerState item) {
      this.builder = new ContainerStateBuilder(this, item);
    }
    ContainerStateBuilder builder;
    
    public N and() {
      return (N) ContainerStatusFluent.this.withLastState(builder.build());
    }
    
    public N endLastState() {
      return and();
    }
    
  
  }
  public class ResourcesNested<N> extends ResourceRequirementsFluent<ResourcesNested<N>> implements Nested<N>{
    ResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) ContainerStatusFluent.this.withResources(builder.build());
    }
    
    public N endResources() {
      return and();
    }
    
  
  }
  public class StateNested<N> extends ContainerStateFluent<StateNested<N>> implements Nested<N>{
    StateNested(ContainerState item) {
      this.builder = new ContainerStateBuilder(this, item);
    }
    ContainerStateBuilder builder;
    
    public N and() {
      return (N) ContainerStatusFluent.this.withState(builder.build());
    }
    
    public N endState() {
      return and();
    }
    
  
  }
  public class UserNested<N> extends ContainerUserFluent<UserNested<N>> implements Nested<N>{
    UserNested(ContainerUser item) {
      this.builder = new ContainerUserBuilder(this, item);
    }
    ContainerUserBuilder builder;
    
    public N and() {
      return (N) ContainerStatusFluent.this.withUser(builder.build());
    }
    
    public N endUser() {
      return and();
    }
    
  
  }
  public class VolumeMountsNested<N> extends VolumeMountStatusFluent<VolumeMountsNested<N>> implements Nested<N>{
    VolumeMountsNested(int index,VolumeMountStatus item) {
      this.index = index;
      this.builder = new VolumeMountStatusBuilder(this, item);
    }
    VolumeMountStatusBuilder builder;
    int index;
    
    public N and() {
      return (N) ContainerStatusFluent.this.setToVolumeMounts(index,builder.build());
    }
    
    public N endVolumeMount() {
      return and();
    }
    
  
  }

}