package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StatusDetailsBuilder extends StatusDetailsFluent<StatusDetailsBuilder> implements VisitableBuilder<StatusDetails,StatusDetailsBuilder>{
  public StatusDetailsBuilder() {
    this(new StatusDetails());
  }
  
  public StatusDetailsBuilder(StatusDetailsFluent<?> fluent) {
    this(fluent, new StatusDetails());
  }
  
  public StatusDetailsBuilder(StatusDetailsFluent<?> fluent,StatusDetails instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StatusDetailsBuilder(StatusDetails instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StatusDetailsFluent<?> fluent;
  
  public StatusDetails build() {
    StatusDetails buildable = new StatusDetails(fluent.buildCauses(),fluent.getGroup(),fluent.getKind(),fluent.getName(),fluent.getRetryAfterSeconds(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}