package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PodResourceClaimBuilder extends PodResourceClaimFluent<PodResourceClaimBuilder> implements VisitableBuilder<PodResourceClaim,PodResourceClaimBuilder>{
  public PodResourceClaimBuilder() {
    this(new PodResourceClaim());
  }
  
  public PodResourceClaimBuilder(PodResourceClaimFluent<?> fluent) {
    this(fluent, new PodResourceClaim());
  }
  
  public PodResourceClaimBuilder(PodResourceClaimFluent<?> fluent,PodResourceClaim instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PodResourceClaimBuilder(PodResourceClaim instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PodResourceClaimFluent<?> fluent;
  
  public PodResourceClaim build() {
    PodResourceClaim buildable = new PodResourceClaim(fluent.getName(),fluent.buildSource());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}