package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WeightedPodAffinityTermBuilder extends WeightedPodAffinityTermFluent<WeightedPodAffinityTermBuilder> implements VisitableBuilder<WeightedPodAffinityTerm,WeightedPodAffinityTermBuilder>{
  public WeightedPodAffinityTermBuilder() {
    this(false);
  }
  public WeightedPodAffinityTermBuilder(Boolean validationEnabled) {
    this(new WeightedPodAffinityTerm(), validationEnabled);
  }
  public WeightedPodAffinityTermBuilder(WeightedPodAffinityTermFluent<?> fluent) {
    this(fluent, false);
  }
  public WeightedPodAffinityTermBuilder(WeightedPodAffinityTermFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WeightedPodAffinityTerm(), validationEnabled);
  }
  public WeightedPodAffinityTermBuilder(WeightedPodAffinityTermFluent<?> fluent,WeightedPodAffinityTerm instance) {
    this(fluent, instance, false);
  }
  public WeightedPodAffinityTermBuilder(WeightedPodAffinityTermFluent<?> fluent,WeightedPodAffinityTerm instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new WeightedPodAffinityTerm());

    if (instance != null) {
      fluent.withPodAffinityTerm(instance.getPodAffinityTerm());
      fluent.withWeight(instance.getWeight());
      fluent.withPodAffinityTerm(instance.getPodAffinityTerm());
      fluent.withWeight(instance.getWeight());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public WeightedPodAffinityTermBuilder(WeightedPodAffinityTerm instance) {
    this(instance,false);
  }
  public WeightedPodAffinityTermBuilder(WeightedPodAffinityTerm instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new WeightedPodAffinityTerm());

    if (instance != null) {
      this.withPodAffinityTerm(instance.getPodAffinityTerm());
      this.withWeight(instance.getWeight());
      this.withPodAffinityTerm(instance.getPodAffinityTerm());
      this.withWeight(instance.getWeight());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  WeightedPodAffinityTermFluent<?> fluent;
  Boolean validationEnabled;
  public WeightedPodAffinityTerm build() {
    WeightedPodAffinityTerm buildable = new WeightedPodAffinityTerm(fluent.buildPodAffinityTerm(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}