package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VolumeProjectionBuilder extends VolumeProjectionFluent<VolumeProjectionBuilder> implements VisitableBuilder<VolumeProjection,VolumeProjectionBuilder>{
  public VolumeProjectionBuilder() {
    this(false);
  }
  public VolumeProjectionBuilder(Boolean validationEnabled) {
    this(new VolumeProjection(), validationEnabled);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VolumeProjection(), validationEnabled);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent,VolumeProjection instance) {
    this(fluent, instance, false);
  }
  public VolumeProjectionBuilder(VolumeProjectionFluent<?> fluent,VolumeProjection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VolumeProjection());

    if (instance != null) {
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withDownwardAPI(instance.getDownwardAPI());
      fluent.withSecret(instance.getSecret());
      fluent.withServiceAccountToken(instance.getServiceAccountToken());
      fluent.withConfigMap(instance.getConfigMap());
      fluent.withDownwardAPI(instance.getDownwardAPI());
      fluent.withSecret(instance.getSecret());
      fluent.withServiceAccountToken(instance.getServiceAccountToken());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VolumeProjectionBuilder(VolumeProjection instance) {
    this(instance,false);
  }
  public VolumeProjectionBuilder(VolumeProjection instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VolumeProjection());

    if (instance != null) {
      this.withConfigMap(instance.getConfigMap());
      this.withDownwardAPI(instance.getDownwardAPI());
      this.withSecret(instance.getSecret());
      this.withServiceAccountToken(instance.getServiceAccountToken());
      this.withConfigMap(instance.getConfigMap());
      this.withDownwardAPI(instance.getDownwardAPI());
      this.withSecret(instance.getSecret());
      this.withServiceAccountToken(instance.getServiceAccountToken());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  VolumeProjectionFluent<?> fluent;
  Boolean validationEnabled;
  public VolumeProjection build() {
    VolumeProjection buildable = new VolumeProjection(fluent.buildConfigMap(),fluent.buildDownwardAPI(),fluent.buildSecret(),fluent.buildServiceAccountToken());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}