package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceQuotaListBuilder extends ResourceQuotaListFluent<ResourceQuotaListBuilder> implements VisitableBuilder<ResourceQuotaList,ResourceQuotaListBuilder>{
  public ResourceQuotaListBuilder() {
    this(false);
  }
  public ResourceQuotaListBuilder(Boolean validationEnabled) {
    this(new ResourceQuotaList(), validationEnabled);
  }
  public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceQuotaList(), validationEnabled);
  }
  public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent,ResourceQuotaList instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaListBuilder(ResourceQuotaListFluent<?> fluent,ResourceQuotaList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ResourceQuotaList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaListBuilder(ResourceQuotaList instance) {
    this(instance,false);
  }
  public ResourceQuotaListBuilder(ResourceQuotaList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ResourceQuotaList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceQuotaListFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceQuotaList build() {
    ResourceQuotaList buildable = new ResourceQuotaList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.buildMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}