package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ProjectedVolumeSourceBuilder extends ProjectedVolumeSourceFluent<ProjectedVolumeSourceBuilder> implements VisitableBuilder<ProjectedVolumeSource,ProjectedVolumeSourceBuilder>{
  public ProjectedVolumeSourceBuilder() {
    this(false);
  }
  public ProjectedVolumeSourceBuilder(Boolean validationEnabled) {
    this(new ProjectedVolumeSource(), validationEnabled);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ProjectedVolumeSource(), validationEnabled);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent,ProjectedVolumeSource instance) {
    this(fluent, instance, false);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSourceFluent<?> fluent,ProjectedVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ProjectedVolumeSource());

    if (instance != null) {
      fluent.withDefaultMode(instance.getDefaultMode());
      fluent.withSources(instance.getSources());
      fluent.withDefaultMode(instance.getDefaultMode());
      fluent.withSources(instance.getSources());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSource instance) {
    this(instance,false);
  }
  public ProjectedVolumeSourceBuilder(ProjectedVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ProjectedVolumeSource());

    if (instance != null) {
      this.withDefaultMode(instance.getDefaultMode());
      this.withSources(instance.getSources());
      this.withDefaultMode(instance.getDefaultMode());
      this.withSources(instance.getSources());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ProjectedVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ProjectedVolumeSource build() {
    ProjectedVolumeSource buildable = new ProjectedVolumeSource(fluent.getDefaultMode(),fluent.buildSources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}