package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PodSecurityContextFluent<A extends PodSecurityContextFluent<A>> extends BaseFluent<A>{
  public PodSecurityContextFluent() {
  }
  public PodSecurityContextFluent(PodSecurityContext instance) {
    instance = (instance != null ? instance : new PodSecurityContext());

    if (instance != null) {
      this.withFsGroup(instance.getFsGroup());
      this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withSupplementalGroups(instance.getSupplementalGroups());
      this.withSysctls(instance.getSysctls());
      this.withWindowsOptions(instance.getWindowsOptions());
      this.withFsGroup(instance.getFsGroup());
      this.withFsGroupChangePolicy(instance.getFsGroupChangePolicy());
      this.withRunAsGroup(instance.getRunAsGroup());
      this.withRunAsNonRoot(instance.getRunAsNonRoot());
      this.withRunAsUser(instance.getRunAsUser());
      this.withSeLinuxOptions(instance.getSeLinuxOptions());
      this.withSeccompProfile(instance.getSeccompProfile());
      this.withSupplementalGroups(instance.getSupplementalGroups());
      this.withSysctls(instance.getSysctls());
      this.withWindowsOptions(instance.getWindowsOptions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Long fsGroup;
  private String fsGroupChangePolicy;
  private Long runAsGroup;
  private Boolean runAsNonRoot;
  private Long runAsUser;
  private SELinuxOptionsBuilder seLinuxOptions;
  private SeccompProfileBuilder seccompProfile;
  private List<Long> supplementalGroups = new ArrayList<Long>();
  private ArrayList<SysctlBuilder> sysctls = new ArrayList<SysctlBuilder>();
  private WindowsSecurityContextOptionsBuilder windowsOptions;
  private Map<String,Object> additionalProperties;
  public Long getFsGroup() {
    return this.fsGroup;
  }
  public A withFsGroup(Long fsGroup) {
    this.fsGroup=fsGroup; return (A) this;
  }
  public boolean hasFsGroup() {
    return this.fsGroup != null;
  }
  public String getFsGroupChangePolicy() {
    return this.fsGroupChangePolicy;
  }
  public A withFsGroupChangePolicy(String fsGroupChangePolicy) {
    this.fsGroupChangePolicy=fsGroupChangePolicy; return (A) this;
  }
  public boolean hasFsGroupChangePolicy() {
    return this.fsGroupChangePolicy != null;
  }
  public Long getRunAsGroup() {
    return this.runAsGroup;
  }
  public A withRunAsGroup(Long runAsGroup) {
    this.runAsGroup=runAsGroup; return (A) this;
  }
  public boolean hasRunAsGroup() {
    return this.runAsGroup != null;
  }
  public Boolean getRunAsNonRoot() {
    return this.runAsNonRoot;
  }
  public A withRunAsNonRoot(Boolean runAsNonRoot) {
    this.runAsNonRoot=runAsNonRoot; return (A) this;
  }
  public boolean hasRunAsNonRoot() {
    return this.runAsNonRoot != null;
  }
  public Long getRunAsUser() {
    return this.runAsUser;
  }
  public A withRunAsUser(Long runAsUser) {
    this.runAsUser=runAsUser; return (A) this;
  }
  public boolean hasRunAsUser() {
    return this.runAsUser != null;
  }
  public SELinuxOptions buildSeLinuxOptions() {
    return this.seLinuxOptions!=null ?this.seLinuxOptions.build():null;
  }
  public A withSeLinuxOptions(SELinuxOptions seLinuxOptions) {
    _visitables.get("seLinuxOptions").remove(this.seLinuxOptions);
    if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.get("seLinuxOptions").add(this.seLinuxOptions);} else { this.seLinuxOptions = null; _visitables.get("seLinuxOptions").remove(this.seLinuxOptions); } return (A) this;
  }
  public boolean hasSeLinuxOptions() {
    return this.seLinuxOptions != null;
  }
  public A withNewSeLinuxOptions(String level,String role,String type,String user) {
    return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
  }
  public SeLinuxOptionsNested<A> withNewSeLinuxOptions() {
    return new SeLinuxOptionsNested(null);
  }
  public SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item) {
    return new SeLinuxOptionsNested(item);
  }
  public SeLinuxOptionsNested<A> editSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(java.util.Optional.ofNullable(buildSeLinuxOptions()).orElse(null));
  }
  public SeLinuxOptionsNested<A> editOrNewSeLinuxOptions() {
    return withNewSeLinuxOptionsLike(java.util.Optional.ofNullable(buildSeLinuxOptions()).orElse(new SELinuxOptionsBuilder().build()));
  }
  public SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item) {
    return withNewSeLinuxOptionsLike(java.util.Optional.ofNullable(buildSeLinuxOptions()).orElse(item));
  }
  public SeccompProfile buildSeccompProfile() {
    return this.seccompProfile!=null ?this.seccompProfile.build():null;
  }
  public A withSeccompProfile(SeccompProfile seccompProfile) {
    _visitables.get("seccompProfile").remove(this.seccompProfile);
    if (seccompProfile!=null){ this.seccompProfile= new SeccompProfileBuilder(seccompProfile); _visitables.get("seccompProfile").add(this.seccompProfile);} else { this.seccompProfile = null; _visitables.get("seccompProfile").remove(this.seccompProfile); } return (A) this;
  }
  public boolean hasSeccompProfile() {
    return this.seccompProfile != null;
  }
  public A withNewSeccompProfile(String localhostProfile,String type) {
    return (A)withSeccompProfile(new SeccompProfile(localhostProfile, type));
  }
  public SeccompProfileNested<A> withNewSeccompProfile() {
    return new SeccompProfileNested(null);
  }
  public SeccompProfileNested<A> withNewSeccompProfileLike(SeccompProfile item) {
    return new SeccompProfileNested(item);
  }
  public SeccompProfileNested<A> editSeccompProfile() {
    return withNewSeccompProfileLike(java.util.Optional.ofNullable(buildSeccompProfile()).orElse(null));
  }
  public SeccompProfileNested<A> editOrNewSeccompProfile() {
    return withNewSeccompProfileLike(java.util.Optional.ofNullable(buildSeccompProfile()).orElse(new SeccompProfileBuilder().build()));
  }
  public SeccompProfileNested<A> editOrNewSeccompProfileLike(SeccompProfile item) {
    return withNewSeccompProfileLike(java.util.Optional.ofNullable(buildSeccompProfile()).orElse(item));
  }
  public A addToSupplementalGroups(int index,Long item) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    this.supplementalGroups.add(index, item);
    return (A)this;
  }
  public A setToSupplementalGroups(int index,Long item) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    this.supplementalGroups.set(index, item); return (A)this;
  }
  public A addToSupplementalGroups(java.lang.Long... items) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
  }
  public A addAllToSupplementalGroups(Collection<Long> items) {
    if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
    for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
  }
  public A removeFromSupplementalGroups(java.lang.Long... items) {
    if (this.supplementalGroups == null) return (A)this;
    for (Long item : items) { this.supplementalGroups.remove(item);} return (A)this;
  }
  public A removeAllFromSupplementalGroups(Collection<Long> items) {
    if (this.supplementalGroups == null) return (A)this;
    for (Long item : items) { this.supplementalGroups.remove(item);} return (A)this;
  }
  public List<Long> getSupplementalGroups() {
    return this.supplementalGroups;
  }
  public Long getSupplementalGroup(int index) {
    return this.supplementalGroups.get(index);
  }
  public Long getFirstSupplementalGroup() {
    return this.supplementalGroups.get(0);
  }
  public Long getLastSupplementalGroup() {
    return this.supplementalGroups.get(supplementalGroups.size() - 1);
  }
  public Long getMatchingSupplementalGroup(Predicate<Long> predicate) {
    for (Long item: supplementalGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingSupplementalGroup(Predicate<Long> predicate) {
    for (Long item: supplementalGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSupplementalGroups(List<Long> supplementalGroups) {
    if (supplementalGroups != null) {this.supplementalGroups = new ArrayList(); for (Long item : supplementalGroups){this.addToSupplementalGroups(item);}} else { this.supplementalGroups = null;} return (A) this;
  }
  public A withSupplementalGroups(java.lang.Long... supplementalGroups) {
    if (this.supplementalGroups != null) {this.supplementalGroups.clear(); _visitables.remove("supplementalGroups"); }
    if (supplementalGroups != null) {for (Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (A) this;
  }
  public boolean hasSupplementalGroups() {
    return supplementalGroups != null && !supplementalGroups.isEmpty();
  }
  public A addToSysctls(int index,Sysctl item) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    SysctlBuilder builder = new SysctlBuilder(item);
    if (index < 0 || index >= sysctls.size()) { _visitables.get("sysctls").add(builder); sysctls.add(builder); } else { _visitables.get("sysctls").add(index, builder); sysctls.add(index, builder);}
    return (A)this;
  }
  public A setToSysctls(int index,Sysctl item) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    SysctlBuilder builder = new SysctlBuilder(item);
    if (index < 0 || index >= sysctls.size()) { _visitables.get("sysctls").add(builder); sysctls.add(builder); } else { _visitables.get("sysctls").set(index, builder); sysctls.set(index, builder);}
    return (A)this;
  }
  public A addToSysctls(io.fabric8.kubernetes.api.model.Sysctl... items) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
  }
  public A addAllToSysctls(Collection<Sysctl> items) {
    if (this.sysctls == null) {this.sysctls = new ArrayList<SysctlBuilder>();}
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").add(builder);this.sysctls.add(builder);} return (A)this;
  }
  public A removeFromSysctls(io.fabric8.kubernetes.api.model.Sysctl... items) {
    if (this.sysctls == null) return (A)this;
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").remove(builder); this.sysctls.remove(builder);} return (A)this;
  }
  public A removeAllFromSysctls(Collection<Sysctl> items) {
    if (this.sysctls == null) return (A)this;
    for (Sysctl item : items) {SysctlBuilder builder = new SysctlBuilder(item);_visitables.get("sysctls").remove(builder); this.sysctls.remove(builder);} return (A)this;
  }
  public A removeMatchingFromSysctls(Predicate<SysctlBuilder> predicate) {
    if (sysctls == null) return (A) this;
    final Iterator<SysctlBuilder> each = sysctls.iterator();
    final List visitables = _visitables.get("sysctls");
    while (each.hasNext()) {
      SysctlBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<Sysctl> buildSysctls() {
    return sysctls != null ? build(sysctls) : null;
  }
  public Sysctl buildSysctl(int index) {
    return this.sysctls.get(index).build();
  }
  public Sysctl buildFirstSysctl() {
    return this.sysctls.get(0).build();
  }
  public Sysctl buildLastSysctl() {
    return this.sysctls.get(sysctls.size() - 1).build();
  }
  public Sysctl buildMatchingSysctl(Predicate<SysctlBuilder> predicate) {
    for (SysctlBuilder item: sysctls) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingSysctl(Predicate<SysctlBuilder> predicate) {
    for (SysctlBuilder item: sysctls) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSysctls(List<Sysctl> sysctls) {
    if (this.sysctls != null) { _visitables.get("sysctls").clear();}
    if (sysctls != null) {this.sysctls = new ArrayList(); for (Sysctl item : sysctls){this.addToSysctls(item);}} else { this.sysctls = null;} return (A) this;
  }
  public A withSysctls(io.fabric8.kubernetes.api.model.Sysctl... sysctls) {
    if (this.sysctls != null) {this.sysctls.clear(); _visitables.remove("sysctls"); }
    if (sysctls != null) {for (Sysctl item :sysctls){ this.addToSysctls(item);}} return (A) this;
  }
  public boolean hasSysctls() {
    return sysctls != null && !sysctls.isEmpty();
  }
  public A addNewSysctl(String name,String value) {
    return (A)addToSysctls(new Sysctl(name, value));
  }
  public SysctlsNested<A> addNewSysctl() {
    return new SysctlsNested(-1, null);
  }
  public SysctlsNested<A> addNewSysctlLike(Sysctl item) {
    return new SysctlsNested(-1, item);
  }
  public SysctlsNested<A> setNewSysctlLike(int index,Sysctl item) {
    return new SysctlsNested(index, item);
  }
  public SysctlsNested<A> editSysctl(int index) {
    if (sysctls.size() <= index) throw new RuntimeException("Can't edit sysctls. Index exceeds size.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public SysctlsNested<A> editFirstSysctl() {
    if (sysctls.size() == 0) throw new RuntimeException("Can't edit first sysctls. The list is empty.");
    return setNewSysctlLike(0, buildSysctl(0));
  }
  public SysctlsNested<A> editLastSysctl() {
    int index = sysctls.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sysctls. The list is empty.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public SysctlsNested<A> editMatchingSysctl(Predicate<SysctlBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sysctls.size();i++) { 
    if (predicate.test(sysctls.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sysctls. No match found.");
    return setNewSysctlLike(index, buildSysctl(index));
  }
  public WindowsSecurityContextOptions buildWindowsOptions() {
    return this.windowsOptions!=null ?this.windowsOptions.build():null;
  }
  public A withWindowsOptions(WindowsSecurityContextOptions windowsOptions) {
    _visitables.get("windowsOptions").remove(this.windowsOptions);
    if (windowsOptions!=null){ this.windowsOptions= new WindowsSecurityContextOptionsBuilder(windowsOptions); _visitables.get("windowsOptions").add(this.windowsOptions);} else { this.windowsOptions = null; _visitables.get("windowsOptions").remove(this.windowsOptions); } return (A) this;
  }
  public boolean hasWindowsOptions() {
    return this.windowsOptions != null;
  }
  public A withNewWindowsOptions(String gmsaCredentialSpec,String gmsaCredentialSpecName,Boolean hostProcess,String runAsUserName) {
    return (A)withWindowsOptions(new WindowsSecurityContextOptions(gmsaCredentialSpec, gmsaCredentialSpecName, hostProcess, runAsUserName));
  }
  public WindowsOptionsNested<A> withNewWindowsOptions() {
    return new WindowsOptionsNested(null);
  }
  public WindowsOptionsNested<A> withNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
    return new WindowsOptionsNested(item);
  }
  public WindowsOptionsNested<A> editWindowsOptions() {
    return withNewWindowsOptionsLike(java.util.Optional.ofNullable(buildWindowsOptions()).orElse(null));
  }
  public WindowsOptionsNested<A> editOrNewWindowsOptions() {
    return withNewWindowsOptionsLike(java.util.Optional.ofNullable(buildWindowsOptions()).orElse(new WindowsSecurityContextOptionsBuilder().build()));
  }
  public WindowsOptionsNested<A> editOrNewWindowsOptionsLike(WindowsSecurityContextOptions item) {
    return withNewWindowsOptionsLike(java.util.Optional.ofNullable(buildWindowsOptions()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PodSecurityContextFluent that = (PodSecurityContextFluent) o;
    if (!java.util.Objects.equals(fsGroup, that.fsGroup)) return false;

    if (!java.util.Objects.equals(fsGroupChangePolicy, that.fsGroupChangePolicy)) return false;

    if (!java.util.Objects.equals(runAsGroup, that.runAsGroup)) return false;

    if (!java.util.Objects.equals(runAsNonRoot, that.runAsNonRoot)) return false;

    if (!java.util.Objects.equals(runAsUser, that.runAsUser)) return false;

    if (!java.util.Objects.equals(seLinuxOptions, that.seLinuxOptions)) return false;

    if (!java.util.Objects.equals(seccompProfile, that.seccompProfile)) return false;

    if (!java.util.Objects.equals(supplementalGroups, that.supplementalGroups)) return false;

    if (!java.util.Objects.equals(sysctls, that.sysctls)) return false;

    if (!java.util.Objects.equals(windowsOptions, that.windowsOptions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fsGroup,  fsGroupChangePolicy,  runAsGroup,  runAsNonRoot,  runAsUser,  seLinuxOptions,  seccompProfile,  supplementalGroups,  sysctls,  windowsOptions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (fsGroup != null) { sb.append("fsGroup:"); sb.append(fsGroup + ","); }
    if (fsGroupChangePolicy != null) { sb.append("fsGroupChangePolicy:"); sb.append(fsGroupChangePolicy + ","); }
    if (runAsGroup != null) { sb.append("runAsGroup:"); sb.append(runAsGroup + ","); }
    if (runAsNonRoot != null) { sb.append("runAsNonRoot:"); sb.append(runAsNonRoot + ","); }
    if (runAsUser != null) { sb.append("runAsUser:"); sb.append(runAsUser + ","); }
    if (seLinuxOptions != null) { sb.append("seLinuxOptions:"); sb.append(seLinuxOptions + ","); }
    if (seccompProfile != null) { sb.append("seccompProfile:"); sb.append(seccompProfile + ","); }
    if (supplementalGroups != null && !supplementalGroups.isEmpty()) { sb.append("supplementalGroups:"); sb.append(supplementalGroups + ","); }
    if (sysctls != null && !sysctls.isEmpty()) { sb.append("sysctls:"); sb.append(sysctls + ","); }
    if (windowsOptions != null) { sb.append("windowsOptions:"); sb.append(windowsOptions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withRunAsNonRoot() {
    return withRunAsNonRoot(true);
  }
  public class SeLinuxOptionsNested<N> extends SELinuxOptionsFluent<SeLinuxOptionsNested<N>> implements Nested<N>{
    SeLinuxOptionsNested(SELinuxOptions item) {
      this.builder = new SELinuxOptionsBuilder(this, item);
    }
    SELinuxOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityContextFluent.this.withSeLinuxOptions(builder.build());
    }
    public N endSeLinuxOptions() {
      return and();
    }
    
  }
  public class SeccompProfileNested<N> extends SeccompProfileFluent<SeccompProfileNested<N>> implements Nested<N>{
    SeccompProfileNested(SeccompProfile item) {
      this.builder = new SeccompProfileBuilder(this, item);
    }
    SeccompProfileBuilder builder;
    public N and() {
      return (N) PodSecurityContextFluent.this.withSeccompProfile(builder.build());
    }
    public N endSeccompProfile() {
      return and();
    }
    
  }
  public class SysctlsNested<N> extends SysctlFluent<SysctlsNested<N>> implements Nested<N>{
    SysctlsNested(int index,Sysctl item) {
      this.index = index;
      this.builder = new SysctlBuilder(this, item);
    }
    SysctlBuilder builder;
    int index;
    public N and() {
      return (N) PodSecurityContextFluent.this.setToSysctls(index,builder.build());
    }
    public N endSysctl() {
      return and();
    }
    
  }
  public class WindowsOptionsNested<N> extends WindowsSecurityContextOptionsFluent<WindowsOptionsNested<N>> implements Nested<N>{
    WindowsOptionsNested(WindowsSecurityContextOptions item) {
      this.builder = new WindowsSecurityContextOptionsBuilder(this, item);
    }
    WindowsSecurityContextOptionsBuilder builder;
    public N and() {
      return (N) PodSecurityContextFluent.this.withWindowsOptions(builder.build());
    }
    public N endWindowsOptions() {
      return and();
    }
    
  }
  
}