package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NodeSelectorTermBuilder extends NodeSelectorTermFluent<NodeSelectorTermBuilder> implements VisitableBuilder<NodeSelectorTerm,NodeSelectorTermBuilder>{
  public NodeSelectorTermBuilder() {
    this(false);
  }
  public NodeSelectorTermBuilder(Boolean validationEnabled) {
    this(new NodeSelectorTerm(), validationEnabled);
  }
  public NodeSelectorTermBuilder(NodeSelectorTermFluent<?> fluent) {
    this(fluent, false);
  }
  public NodeSelectorTermBuilder(NodeSelectorTermFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new NodeSelectorTerm(), validationEnabled);
  }
  public NodeSelectorTermBuilder(NodeSelectorTermFluent<?> fluent,NodeSelectorTerm instance) {
    this(fluent, instance, false);
  }
  public NodeSelectorTermBuilder(NodeSelectorTermFluent<?> fluent,NodeSelectorTerm instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new NodeSelectorTerm());

    if (instance != null) {
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withMatchFields(instance.getMatchFields());
      fluent.withMatchExpressions(instance.getMatchExpressions());
      fluent.withMatchFields(instance.getMatchFields());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public NodeSelectorTermBuilder(NodeSelectorTerm instance) {
    this(instance,false);
  }
  public NodeSelectorTermBuilder(NodeSelectorTerm instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new NodeSelectorTerm());

    if (instance != null) {
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withMatchFields(instance.getMatchFields());
      this.withMatchExpressions(instance.getMatchExpressions());
      this.withMatchFields(instance.getMatchFields());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  NodeSelectorTermFluent<?> fluent;
  Boolean validationEnabled;
  public NodeSelectorTerm build() {
    NodeSelectorTerm buildable = new NodeSelectorTerm(fluent.buildMatchExpressions(),fluent.buildMatchFields());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}