package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerStatusBuilder extends LoadBalancerStatusFluent<LoadBalancerStatusBuilder> implements VisitableBuilder<LoadBalancerStatus,LoadBalancerStatusBuilder>{
  public LoadBalancerStatusBuilder() {
    this(false);
  }
  public LoadBalancerStatusBuilder(Boolean validationEnabled) {
    this(new LoadBalancerStatus(), validationEnabled);
  }
  public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoadBalancerStatus(), validationEnabled);
  }
  public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent,LoadBalancerStatus instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerStatusBuilder(LoadBalancerStatusFluent<?> fluent,LoadBalancerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LoadBalancerStatus());

    if (instance != null) {
      fluent.withIngress(instance.getIngress());
      fluent.withIngress(instance.getIngress());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerStatusBuilder(LoadBalancerStatus instance) {
    this(instance,false);
  }
  public LoadBalancerStatusBuilder(LoadBalancerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LoadBalancerStatus());

    if (instance != null) {
      this.withIngress(instance.getIngress());
      this.withIngress(instance.getIngress());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LoadBalancerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public LoadBalancerStatus build() {
    LoadBalancerStatus buildable = new LoadBalancerStatus(fluent.buildIngress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}