package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleBuilder extends LifecycleFluent<LifecycleBuilder> implements VisitableBuilder<Lifecycle,LifecycleBuilder>{
  public LifecycleBuilder() {
    this(false);
  }
  public LifecycleBuilder(Boolean validationEnabled) {
    this(new Lifecycle(), validationEnabled);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Lifecycle(), validationEnabled);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance) {
    this(fluent, instance, false);
  }
  public LifecycleBuilder(LifecycleFluent<?> fluent,Lifecycle instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Lifecycle());

    if (instance != null) {
      fluent.withPostStart(instance.getPostStart());
      fluent.withPreStop(instance.getPreStop());
      fluent.withPostStart(instance.getPostStart());
      fluent.withPreStop(instance.getPreStop());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LifecycleBuilder(Lifecycle instance) {
    this(instance,false);
  }
  public LifecycleBuilder(Lifecycle instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Lifecycle());

    if (instance != null) {
      this.withPostStart(instance.getPostStart());
      this.withPreStop(instance.getPreStop());
      this.withPostStart(instance.getPostStart());
      this.withPreStop(instance.getPreStop());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LifecycleFluent<?> fluent;
  Boolean validationEnabled;
  public Lifecycle build() {
    Lifecycle buildable = new Lifecycle(fluent.buildPostStart(),fluent.buildPreStop());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}