package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostAliasBuilder extends HostAliasFluent<HostAliasBuilder> implements VisitableBuilder<HostAlias,HostAliasBuilder>{
  public HostAliasBuilder() {
    this(false);
  }
  public HostAliasBuilder(Boolean validationEnabled) {
    this(new HostAlias(), validationEnabled);
  }
  public HostAliasBuilder(HostAliasFluent<?> fluent) {
    this(fluent, false);
  }
  public HostAliasBuilder(HostAliasFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HostAlias(), validationEnabled);
  }
  public HostAliasBuilder(HostAliasFluent<?> fluent,HostAlias instance) {
    this(fluent, instance, false);
  }
  public HostAliasBuilder(HostAliasFluent<?> fluent,HostAlias instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HostAlias());

    if (instance != null) {
      fluent.withHostnames(instance.getHostnames());
      fluent.withIp(instance.getIp());
      fluent.withHostnames(instance.getHostnames());
      fluent.withIp(instance.getIp());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HostAliasBuilder(HostAlias instance) {
    this(instance,false);
  }
  public HostAliasBuilder(HostAlias instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HostAlias());

    if (instance != null) {
      this.withHostnames(instance.getHostnames());
      this.withIp(instance.getIp());
      this.withHostnames(instance.getHostnames());
      this.withIp(instance.getIp());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HostAliasFluent<?> fluent;
  Boolean validationEnabled;
  public HostAlias build() {
    HostAlias buildable = new HostAlias(fluent.getHostnames(),fluent.getIp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}