package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupVersionForDiscoveryBuilder extends GroupVersionForDiscoveryFluent<GroupVersionForDiscoveryBuilder> implements VisitableBuilder<GroupVersionForDiscovery,GroupVersionForDiscoveryBuilder>{
  public GroupVersionForDiscoveryBuilder() {
    this(false);
  }
  public GroupVersionForDiscoveryBuilder(Boolean validationEnabled) {
    this(new GroupVersionForDiscovery(), validationEnabled);
  }
  public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GroupVersionForDiscovery(), validationEnabled);
  }
  public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent,GroupVersionForDiscovery instance) {
    this(fluent, instance, false);
  }
  public GroupVersionForDiscoveryBuilder(GroupVersionForDiscoveryFluent<?> fluent,GroupVersionForDiscovery instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GroupVersionForDiscovery());

    if (instance != null) {
      fluent.withGroupVersion(instance.getGroupVersion());
      fluent.withVersion(instance.getVersion());
      fluent.withGroupVersion(instance.getGroupVersion());
      fluent.withVersion(instance.getVersion());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance) {
    this(instance,false);
  }
  public GroupVersionForDiscoveryBuilder(GroupVersionForDiscovery instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GroupVersionForDiscovery());

    if (instance != null) {
      this.withGroupVersion(instance.getGroupVersion());
      this.withVersion(instance.getVersion());
      this.withGroupVersion(instance.getGroupVersion());
      this.withVersion(instance.getVersion());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GroupVersionForDiscoveryFluent<?> fluent;
  Boolean validationEnabled;
  public GroupVersionForDiscovery build() {
    GroupVersionForDiscovery buildable = new GroupVersionForDiscovery(fluent.getGroupVersion(),fluent.getVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}