package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GlusterfsVolumeSourceBuilder extends GlusterfsVolumeSourceFluent<GlusterfsVolumeSourceBuilder> implements VisitableBuilder<GlusterfsVolumeSource,GlusterfsVolumeSourceBuilder>{
  public GlusterfsVolumeSourceBuilder() {
    this(false);
  }
  public GlusterfsVolumeSourceBuilder(Boolean validationEnabled) {
    this(new GlusterfsVolumeSource(), validationEnabled);
  }
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new GlusterfsVolumeSource(), validationEnabled);
  }
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent,GlusterfsVolumeSource instance) {
    this(fluent, instance, false);
  }
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent,GlusterfsVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new GlusterfsVolumeSource());

    if (instance != null) {
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withEndpoints(instance.getEndpoints());
      fluent.withPath(instance.getPath());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSource instance) {
    this(instance,false);
  }
  public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new GlusterfsVolumeSource());

    if (instance != null) {
      this.withEndpoints(instance.getEndpoints());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withEndpoints(instance.getEndpoints());
      this.withPath(instance.getPath());
      this.withReadOnly(instance.getReadOnly());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  GlusterfsVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public GlusterfsVolumeSource build() {
    GlusterfsVolumeSource buildable = new GlusterfsVolumeSource(fluent.getEndpoints(),fluent.getPath(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}