package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExecActionBuilder extends ExecActionFluent<ExecActionBuilder> implements VisitableBuilder<ExecAction,ExecActionBuilder>{
  public ExecActionBuilder() {
    this(false);
  }
  public ExecActionBuilder(Boolean validationEnabled) {
    this(new ExecAction(), validationEnabled);
  }
  public ExecActionBuilder(ExecActionFluent<?> fluent) {
    this(fluent, false);
  }
  public ExecActionBuilder(ExecActionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExecAction(), validationEnabled);
  }
  public ExecActionBuilder(ExecActionFluent<?> fluent,ExecAction instance) {
    this(fluent, instance, false);
  }
  public ExecActionBuilder(ExecActionFluent<?> fluent,ExecAction instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExecAction());

    if (instance != null) {
      fluent.withCommand(instance.getCommand());
      fluent.withCommand(instance.getCommand());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExecActionBuilder(ExecAction instance) {
    this(instance,false);
  }
  public ExecActionBuilder(ExecAction instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExecAction());

    if (instance != null) {
      this.withCommand(instance.getCommand());
      this.withCommand(instance.getCommand());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExecActionFluent<?> fluent;
  Boolean validationEnabled;
  public ExecAction build() {
    ExecAction buildable = new ExecAction(fluent.getCommand());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}