package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EphemeralContainerBuilder extends EphemeralContainerFluent<EphemeralContainerBuilder> implements VisitableBuilder<EphemeralContainer,EphemeralContainerBuilder>{
  public EphemeralContainerBuilder() {
    this(false);
  }
  public EphemeralContainerBuilder(Boolean validationEnabled) {
    this(new EphemeralContainer(), validationEnabled);
  }
  public EphemeralContainerBuilder(EphemeralContainerFluent<?> fluent) {
    this(fluent, false);
  }
  public EphemeralContainerBuilder(EphemeralContainerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EphemeralContainer(), validationEnabled);
  }
  public EphemeralContainerBuilder(EphemeralContainerFluent<?> fluent,EphemeralContainer instance) {
    this(fluent, instance, false);
  }
  public EphemeralContainerBuilder(EphemeralContainerFluent<?> fluent,EphemeralContainer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EphemeralContainer());

    if (instance != null) {
      fluent.withArgs(instance.getArgs());
      fluent.withCommand(instance.getCommand());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withImage(instance.getImage());
      fluent.withImagePullPolicy(instance.getImagePullPolicy());
      fluent.withLifecycle(instance.getLifecycle());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withName(instance.getName());
      fluent.withPorts(instance.getPorts());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withResizePolicy(instance.getResizePolicy());
      fluent.withResources(instance.getResources());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withStartupProbe(instance.getStartupProbe());
      fluent.withStdin(instance.getStdin());
      fluent.withStdinOnce(instance.getStdinOnce());
      fluent.withTargetContainerName(instance.getTargetContainerName());
      fluent.withTerminationMessagePath(instance.getTerminationMessagePath());
      fluent.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      fluent.withTty(instance.getTty());
      fluent.withVolumeDevices(instance.getVolumeDevices());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withWorkingDir(instance.getWorkingDir());
      fluent.withArgs(instance.getArgs());
      fluent.withCommand(instance.getCommand());
      fluent.withEnv(instance.getEnv());
      fluent.withEnvFrom(instance.getEnvFrom());
      fluent.withImage(instance.getImage());
      fluent.withImagePullPolicy(instance.getImagePullPolicy());
      fluent.withLifecycle(instance.getLifecycle());
      fluent.withLivenessProbe(instance.getLivenessProbe());
      fluent.withName(instance.getName());
      fluent.withPorts(instance.getPorts());
      fluent.withReadinessProbe(instance.getReadinessProbe());
      fluent.withResizePolicy(instance.getResizePolicy());
      fluent.withResources(instance.getResources());
      fluent.withSecurityContext(instance.getSecurityContext());
      fluent.withStartupProbe(instance.getStartupProbe());
      fluent.withStdin(instance.getStdin());
      fluent.withStdinOnce(instance.getStdinOnce());
      fluent.withTargetContainerName(instance.getTargetContainerName());
      fluent.withTerminationMessagePath(instance.getTerminationMessagePath());
      fluent.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      fluent.withTty(instance.getTty());
      fluent.withVolumeDevices(instance.getVolumeDevices());
      fluent.withVolumeMounts(instance.getVolumeMounts());
      fluent.withWorkingDir(instance.getWorkingDir());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EphemeralContainerBuilder(EphemeralContainer instance) {
    this(instance,false);
  }
  public EphemeralContainerBuilder(EphemeralContainer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EphemeralContainer());

    if (instance != null) {
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withImage(instance.getImage());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withLifecycle(instance.getLifecycle());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withName(instance.getName());
      this.withPorts(instance.getPorts());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withResizePolicy(instance.getResizePolicy());
      this.withResources(instance.getResources());
      this.withSecurityContext(instance.getSecurityContext());
      this.withStartupProbe(instance.getStartupProbe());
      this.withStdin(instance.getStdin());
      this.withStdinOnce(instance.getStdinOnce());
      this.withTargetContainerName(instance.getTargetContainerName());
      this.withTerminationMessagePath(instance.getTerminationMessagePath());
      this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      this.withTty(instance.getTty());
      this.withVolumeDevices(instance.getVolumeDevices());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withWorkingDir(instance.getWorkingDir());
      this.withArgs(instance.getArgs());
      this.withCommand(instance.getCommand());
      this.withEnv(instance.getEnv());
      this.withEnvFrom(instance.getEnvFrom());
      this.withImage(instance.getImage());
      this.withImagePullPolicy(instance.getImagePullPolicy());
      this.withLifecycle(instance.getLifecycle());
      this.withLivenessProbe(instance.getLivenessProbe());
      this.withName(instance.getName());
      this.withPorts(instance.getPorts());
      this.withReadinessProbe(instance.getReadinessProbe());
      this.withResizePolicy(instance.getResizePolicy());
      this.withResources(instance.getResources());
      this.withSecurityContext(instance.getSecurityContext());
      this.withStartupProbe(instance.getStartupProbe());
      this.withStdin(instance.getStdin());
      this.withStdinOnce(instance.getStdinOnce());
      this.withTargetContainerName(instance.getTargetContainerName());
      this.withTerminationMessagePath(instance.getTerminationMessagePath());
      this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
      this.withTty(instance.getTty());
      this.withVolumeDevices(instance.getVolumeDevices());
      this.withVolumeMounts(instance.getVolumeMounts());
      this.withWorkingDir(instance.getWorkingDir());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  EphemeralContainerFluent<?> fluent;
  Boolean validationEnabled;
  public EphemeralContainer build() {
    EphemeralContainer buildable = new EphemeralContainer(fluent.getArgs(),fluent.getCommand(),fluent.buildEnv(),fluent.buildEnvFrom(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.buildLifecycle(),fluent.buildLivenessProbe(),fluent.getName(),fluent.buildPorts(),fluent.buildReadinessProbe(),fluent.buildResizePolicy(),fluent.buildResources(),fluent.buildSecurityContext(),fluent.buildStartupProbe(),fluent.getStdin(),fluent.getStdinOnce(),fluent.getTargetContainerName(),fluent.getTerminationMessagePath(),fluent.getTerminationMessagePolicy(),fluent.getTty(),fluent.buildVolumeDevices(),fluent.buildVolumeMounts(),fluent.getWorkingDir());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}