package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DaemonEndpointBuilder extends DaemonEndpointFluent<DaemonEndpointBuilder> implements VisitableBuilder<DaemonEndpoint,DaemonEndpointBuilder>{
  public DaemonEndpointBuilder() {
    this(false);
  }
  public DaemonEndpointBuilder(Boolean validationEnabled) {
    this(new DaemonEndpoint(), validationEnabled);
  }
  public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent) {
    this(fluent, false);
  }
  public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DaemonEndpoint(), validationEnabled);
  }
  public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent,DaemonEndpoint instance) {
    this(fluent, instance, false);
  }
  public DaemonEndpointBuilder(DaemonEndpointFluent<?> fluent,DaemonEndpoint instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DaemonEndpoint());

    if (instance != null) {
      fluent.withPort(instance.getPort());
      fluent.withPort(instance.getPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DaemonEndpointBuilder(DaemonEndpoint instance) {
    this(instance,false);
  }
  public DaemonEndpointBuilder(DaemonEndpoint instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DaemonEndpoint());

    if (instance != null) {
      this.withPort(instance.getPort());
      this.withPort(instance.getPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DaemonEndpointFluent<?> fluent;
  Boolean validationEnabled;
  public DaemonEndpoint build() {
    DaemonEndpoint buildable = new DaemonEndpoint(fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}