package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CreateOptionsBuilder extends CreateOptionsFluent<CreateOptionsBuilder> implements VisitableBuilder<CreateOptions,CreateOptionsBuilder>{
  public CreateOptionsBuilder() {
    this(false);
  }
  public CreateOptionsBuilder(Boolean validationEnabled) {
    this(new CreateOptions(), validationEnabled);
  }
  public CreateOptionsBuilder(CreateOptionsFluent<?> fluent) {
    this(fluent, false);
  }
  public CreateOptionsBuilder(CreateOptionsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CreateOptions(), validationEnabled);
  }
  public CreateOptionsBuilder(CreateOptionsFluent<?> fluent,CreateOptions instance) {
    this(fluent, instance, false);
  }
  public CreateOptionsBuilder(CreateOptionsFluent<?> fluent,CreateOptions instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CreateOptions());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDryRun(instance.getDryRun());
      fluent.withFieldManager(instance.getFieldManager());
      fluent.withFieldValidation(instance.getFieldValidation());
      fluent.withKind(instance.getKind());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withDryRun(instance.getDryRun());
      fluent.withFieldManager(instance.getFieldManager());
      fluent.withFieldValidation(instance.getFieldValidation());
      fluent.withKind(instance.getKind());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CreateOptionsBuilder(CreateOptions instance) {
    this(instance,false);
  }
  public CreateOptionsBuilder(CreateOptions instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CreateOptions());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withDryRun(instance.getDryRun());
      this.withFieldManager(instance.getFieldManager());
      this.withFieldValidation(instance.getFieldValidation());
      this.withKind(instance.getKind());
      this.withApiVersion(instance.getApiVersion());
      this.withDryRun(instance.getDryRun());
      this.withFieldManager(instance.getFieldManager());
      this.withFieldValidation(instance.getFieldValidation());
      this.withKind(instance.getKind());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CreateOptionsFluent<?> fluent;
  Boolean validationEnabled;
  public CreateOptions build() {
    CreateOptions buildable = new CreateOptions(fluent.getApiVersion(),fluent.getDryRun(),fluent.getFieldManager(),fluent.getFieldValidation(),fluent.getKind());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}