package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerImageBuilder extends ContainerImageFluent<ContainerImageBuilder> implements VisitableBuilder<ContainerImage,ContainerImageBuilder>{
  public ContainerImageBuilder() {
    this(false);
  }
  public ContainerImageBuilder(Boolean validationEnabled) {
    this(new ContainerImage(), validationEnabled);
  }
  public ContainerImageBuilder(ContainerImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerImageBuilder(ContainerImageFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerImage(), validationEnabled);
  }
  public ContainerImageBuilder(ContainerImageFluent<?> fluent,ContainerImage instance) {
    this(fluent, instance, false);
  }
  public ContainerImageBuilder(ContainerImageFluent<?> fluent,ContainerImage instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerImage());

    if (instance != null) {
      fluent.withNames(instance.getNames());
      fluent.withSizeBytes(instance.getSizeBytes());
      fluent.withNames(instance.getNames());
      fluent.withSizeBytes(instance.getSizeBytes());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerImageBuilder(ContainerImage instance) {
    this(instance,false);
  }
  public ContainerImageBuilder(ContainerImage instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerImage());

    if (instance != null) {
      this.withNames(instance.getNames());
      this.withSizeBytes(instance.getSizeBytes());
      this.withNames(instance.getNames());
      this.withSizeBytes(instance.getSizeBytes());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerImageFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerImage build() {
    ContainerImage buildable = new ContainerImage(fluent.getNames(),fluent.getSizeBytes());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}