package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CinderVolumeSourceBuilder extends CinderVolumeSourceFluent<CinderVolumeSourceBuilder> implements VisitableBuilder<CinderVolumeSource,CinderVolumeSourceBuilder>{
  public CinderVolumeSourceBuilder() {
    this(false);
  }
  public CinderVolumeSourceBuilder(Boolean validationEnabled) {
    this(new CinderVolumeSource(), validationEnabled);
  }
  public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CinderVolumeSource(), validationEnabled);
  }
  public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent,CinderVolumeSource instance) {
    this(fluent, instance, false);
  }
  public CinderVolumeSourceBuilder(CinderVolumeSourceFluent<?> fluent,CinderVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CinderVolumeSource());

    if (instance != null) {
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeID(instance.getVolumeID());
      fluent.withFsType(instance.getFsType());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withSecretRef(instance.getSecretRef());
      fluent.withVolumeID(instance.getVolumeID());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CinderVolumeSourceBuilder(CinderVolumeSource instance) {
    this(instance,false);
  }
  public CinderVolumeSourceBuilder(CinderVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CinderVolumeSource());

    if (instance != null) {
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeID(instance.getVolumeID());
      this.withFsType(instance.getFsType());
      this.withReadOnly(instance.getReadOnly());
      this.withSecretRef(instance.getSecretRef());
      this.withVolumeID(instance.getVolumeID());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CinderVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public CinderVolumeSource build() {
    CinderVolumeSource buildable = new CinderVolumeSource(fluent.getFsType(),fluent.getReadOnly(),fluent.buildSecretRef(),fluent.getVolumeID());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}