package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class BindingBuilder extends BindingFluent<BindingBuilder> implements VisitableBuilder<Binding,BindingBuilder>{
  public BindingBuilder() {
    this(false);
  }
  public BindingBuilder(Boolean validationEnabled) {
    this(new Binding(), validationEnabled);
  }
  public BindingBuilder(BindingFluent<?> fluent) {
    this(fluent, false);
  }
  public BindingBuilder(BindingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Binding(), validationEnabled);
  }
  public BindingBuilder(BindingFluent<?> fluent,Binding instance) {
    this(fluent, instance, false);
  }
  public BindingBuilder(BindingFluent<?> fluent,Binding instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Binding());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withTarget(instance.getTarget());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withTarget(instance.getTarget());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public BindingBuilder(Binding instance) {
    this(instance,false);
  }
  public BindingBuilder(Binding instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Binding());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTarget(instance.getTarget());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  BindingFluent<?> fluent;
  Boolean validationEnabled;
  public Binding build() {
    Binding buildable = new Binding(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}