package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TopologySelectorTermFluentImpl<A extends TopologySelectorTermFluent<A>> extends BaseFluent<A> implements TopologySelectorTermFluent<A>{
  public TopologySelectorTermFluentImpl() {
  }
  public TopologySelectorTermFluentImpl(TopologySelectorTerm instance) {
    if (instance != null) {
      this.withMatchLabelExpressions(instance.getMatchLabelExpressions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<TopologySelectorLabelRequirementBuilder> matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToMatchLabelExpressions(int index,TopologySelectorLabelRequirement item) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
    if (index < 0 || index >= matchLabelExpressions.size()) { _visitables.get("matchLabelExpressions").add(builder); matchLabelExpressions.add(builder); } else { _visitables.get("matchLabelExpressions").add(index, builder); matchLabelExpressions.add(index, builder);}
    return (A)this;
  }
  public A setToMatchLabelExpressions(int index,TopologySelectorLabelRequirement item) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);
    if (index < 0 || index >= matchLabelExpressions.size()) { _visitables.get("matchLabelExpressions").add(builder); matchLabelExpressions.add(builder); } else { _visitables.get("matchLabelExpressions").set(index, builder); matchLabelExpressions.set(index, builder);}
    return (A)this;
  }
  public A addToMatchLabelExpressions(io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement... items) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").add(builder);this.matchLabelExpressions.add(builder);} return (A)this;
  }
  public A addAllToMatchLabelExpressions(Collection<TopologySelectorLabelRequirement> items) {
    if (this.matchLabelExpressions == null) {this.matchLabelExpressions = new ArrayList<TopologySelectorLabelRequirementBuilder>();}
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").add(builder);this.matchLabelExpressions.add(builder);} return (A)this;
  }
  public A removeFromMatchLabelExpressions(io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement... items) {
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").remove(builder);if (this.matchLabelExpressions != null) {this.matchLabelExpressions.remove(builder);}} return (A)this;
  }
  public A removeAllFromMatchLabelExpressions(Collection<TopologySelectorLabelRequirement> items) {
    for (TopologySelectorLabelRequirement item : items) {TopologySelectorLabelRequirementBuilder builder = new TopologySelectorLabelRequirementBuilder(item);_visitables.get("matchLabelExpressions").remove(builder);if (this.matchLabelExpressions != null) {this.matchLabelExpressions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromMatchLabelExpressions(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
    if (matchLabelExpressions == null) return (A) this;
    final Iterator<TopologySelectorLabelRequirementBuilder> each = matchLabelExpressions.iterator();
    final List visitables = _visitables.get("matchLabelExpressions");
    while (each.hasNext()) {
      TopologySelectorLabelRequirementBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchLabelExpressions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TopologySelectorLabelRequirement> getMatchLabelExpressions() {
    return matchLabelExpressions != null ? build(matchLabelExpressions) : null;
  }
  public List<TopologySelectorLabelRequirement> buildMatchLabelExpressions() {
    return matchLabelExpressions != null ? build(matchLabelExpressions) : null;
  }
  public TopologySelectorLabelRequirement buildMatchLabelExpression(int index) {
    return this.matchLabelExpressions.get(index).build();
  }
  public TopologySelectorLabelRequirement buildFirstMatchLabelExpression() {
    return this.matchLabelExpressions.get(0).build();
  }
  public TopologySelectorLabelRequirement buildLastMatchLabelExpression() {
    return this.matchLabelExpressions.get(matchLabelExpressions.size() - 1).build();
  }
  public TopologySelectorLabelRequirement buildMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
    for (TopologySelectorLabelRequirementBuilder item: matchLabelExpressions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
    for (TopologySelectorLabelRequirementBuilder item: matchLabelExpressions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMatchLabelExpressions(List<TopologySelectorLabelRequirement> matchLabelExpressions) {
    if (this.matchLabelExpressions != null) { _visitables.get("matchLabelExpressions").clear();}
    if (matchLabelExpressions != null) {this.matchLabelExpressions = new ArrayList(); for (TopologySelectorLabelRequirement item : matchLabelExpressions){this.addToMatchLabelExpressions(item);}} else { this.matchLabelExpressions = null;} return (A) this;
  }
  public A withMatchLabelExpressions(io.fabric8.kubernetes.api.model.TopologySelectorLabelRequirement... matchLabelExpressions) {
    if (this.matchLabelExpressions != null) {this.matchLabelExpressions.clear(); _visitables.remove("matchLabelExpressions"); }
    if (matchLabelExpressions != null) {for (TopologySelectorLabelRequirement item :matchLabelExpressions){ this.addToMatchLabelExpressions(item);}} return (A) this;
  }
  public Boolean hasMatchLabelExpressions() {
    return matchLabelExpressions != null && !matchLabelExpressions.isEmpty();
  }
  public TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<A> addNewMatchLabelExpression() {
    return new TopologySelectorTermFluentImpl.MatchLabelExpressionsNestedImpl();
  }
  public TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<A> addNewMatchLabelExpressionLike(TopologySelectorLabelRequirement item) {
    return new TopologySelectorTermFluentImpl.MatchLabelExpressionsNestedImpl(-1, item);
  }
  public TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<A> setNewMatchLabelExpressionLike(int index,TopologySelectorLabelRequirement item) {
    return new TopologySelectorTermFluentImpl.MatchLabelExpressionsNestedImpl(index, item);
  }
  public TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<A> editMatchLabelExpression(int index) {
    if (matchLabelExpressions.size() <= index) throw new RuntimeException("Can't edit matchLabelExpressions. Index exceeds size.");
    return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
  }
  public TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<A> editFirstMatchLabelExpression() {
    if (matchLabelExpressions.size() == 0) throw new RuntimeException("Can't edit first matchLabelExpressions. The list is empty.");
    return setNewMatchLabelExpressionLike(0, buildMatchLabelExpression(0));
  }
  public TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<A> editLastMatchLabelExpression() {
    int index = matchLabelExpressions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last matchLabelExpressions. The list is empty.");
    return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
  }
  public TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<A> editMatchingMatchLabelExpression(Predicate<TopologySelectorLabelRequirementBuilder> predicate) {
    int index = -1;
    for (int i=0;i<matchLabelExpressions.size();i++) { 
    if (predicate.test(matchLabelExpressions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching matchLabelExpressions. No match found.");
    return setNewMatchLabelExpressionLike(index, buildMatchLabelExpression(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TopologySelectorTermFluentImpl that = (TopologySelectorTermFluentImpl) o;
    if (!java.util.Objects.equals(matchLabelExpressions, that.matchLabelExpressions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(matchLabelExpressions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (matchLabelExpressions != null && !matchLabelExpressions.isEmpty()) { sb.append("matchLabelExpressions:"); sb.append(matchLabelExpressions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MatchLabelExpressionsNestedImpl<N> extends TopologySelectorLabelRequirementFluentImpl<TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<N>> implements TopologySelectorTermFluentImpl.MatchLabelExpressionsNested<N>,Nested<N>{
    MatchLabelExpressionsNestedImpl(int index,TopologySelectorLabelRequirement item) {
      this.index = index;
      this.builder = new TopologySelectorLabelRequirementBuilder(this, item);
    }
    MatchLabelExpressionsNestedImpl() {
      this.index = -1;
      this.builder = new TopologySelectorLabelRequirementBuilder(this);
    }
    TopologySelectorLabelRequirementBuilder builder;
    int index;
    public N and() {
      return (N) TopologySelectorTermFluentImpl.this.setToMatchLabelExpressions(index,builder.build());
    }
    public N endMatchLabelExpression() {
      return and();
    }
    
  }
  
}