package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServicePortBuilder extends ServicePortFluentImpl<ServicePortBuilder> implements VisitableBuilder<ServicePort,ServicePortBuilder>{
  public ServicePortBuilder() {
    this(false);
  }
  public ServicePortBuilder(Boolean validationEnabled) {
    this(new ServicePort(), validationEnabled);
  }
  public ServicePortBuilder(ServicePortFluent<?> fluent) {
    this(fluent, false);
  }
  public ServicePortBuilder(ServicePortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServicePort(), validationEnabled);
  }
  public ServicePortBuilder(ServicePortFluent<?> fluent,ServicePort instance) {
    this(fluent, instance, false);
  }
  public ServicePortBuilder(ServicePortFluent<?> fluent,ServicePort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAppProtocol(instance.getAppProtocol());
      fluent.withName(instance.getName());
      fluent.withNodePort(instance.getNodePort());
      fluent.withPort(instance.getPort());
      fluent.withProtocol(instance.getProtocol());
      fluent.withTargetPort(instance.getTargetPort());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServicePortBuilder(ServicePort instance) {
    this(instance,false);
  }
  public ServicePortBuilder(ServicePort instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAppProtocol(instance.getAppProtocol());
      this.withName(instance.getName());
      this.withNodePort(instance.getNodePort());
      this.withPort(instance.getPort());
      this.withProtocol(instance.getProtocol());
      this.withTargetPort(instance.getTargetPort());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServicePortFluent<?> fluent;
  Boolean validationEnabled;
  public ServicePort build() {
    ServicePort buildable = new ServicePort(fluent.getAppProtocol(),fluent.getName(),fluent.getNodePort(),fluent.getPort(),fluent.getProtocol(),fluent.getTargetPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}