package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SecretReferenceBuilder extends SecretReferenceFluentImpl<SecretReferenceBuilder> implements VisitableBuilder<SecretReference,SecretReferenceBuilder>{
  public SecretReferenceBuilder() {
    this(false);
  }
  public SecretReferenceBuilder(Boolean validationEnabled) {
    this(new SecretReference(), validationEnabled);
  }
  public SecretReferenceBuilder(SecretReferenceFluent<?> fluent) {
    this(fluent, false);
  }
  public SecretReferenceBuilder(SecretReferenceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SecretReference(), validationEnabled);
  }
  public SecretReferenceBuilder(SecretReferenceFluent<?> fluent,SecretReference instance) {
    this(fluent, instance, false);
  }
  public SecretReferenceBuilder(SecretReferenceFluent<?> fluent,SecretReference instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNamespace(instance.getNamespace());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SecretReferenceBuilder(SecretReference instance) {
    this(instance,false);
  }
  public SecretReferenceBuilder(SecretReference instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withNamespace(instance.getNamespace());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SecretReferenceFluent<?> fluent;
  Boolean validationEnabled;
  public SecretReference build() {
    SecretReference buildable = new SecretReference(fluent.getName(),fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}