package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceQuotaStatusBuilder extends ResourceQuotaStatusFluentImpl<ResourceQuotaStatusBuilder> implements VisitableBuilder<ResourceQuotaStatus,ResourceQuotaStatusBuilder>{
  public ResourceQuotaStatusBuilder() {
    this(false);
  }
  public ResourceQuotaStatusBuilder(Boolean validationEnabled) {
    this(new ResourceQuotaStatus(), validationEnabled);
  }
  public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ResourceQuotaStatus(), validationEnabled);
  }
  public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent,ResourceQuotaStatus instance) {
    this(fluent, instance, false);
  }
  public ResourceQuotaStatusBuilder(ResourceQuotaStatusFluent<?> fluent,ResourceQuotaStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withHard(instance.getHard());
      fluent.withUsed(instance.getUsed());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ResourceQuotaStatusBuilder(ResourceQuotaStatus instance) {
    this(instance,false);
  }
  public ResourceQuotaStatusBuilder(ResourceQuotaStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withHard(instance.getHard());
      this.withUsed(instance.getUsed());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ResourceQuotaStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ResourceQuotaStatus build() {
    ResourceQuotaStatus buildable = new ResourceQuotaStatus(fluent.getHard(),fluent.getUsed());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}