package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReplicationControllerBuilder extends ReplicationControllerFluentImpl<ReplicationControllerBuilder> implements VisitableBuilder<ReplicationController,ReplicationControllerBuilder>{
  public ReplicationControllerBuilder() {
    this(false);
  }
  public ReplicationControllerBuilder(Boolean validationEnabled) {
    this(new ReplicationController(), validationEnabled);
  }
  public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent) {
    this(fluent, false);
  }
  public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReplicationController(), validationEnabled);
  }
  public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent,ReplicationController instance) {
    this(fluent, instance, false);
  }
  public ReplicationControllerBuilder(ReplicationControllerFluent<?> fluent,ReplicationController instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReplicationControllerBuilder(ReplicationController instance) {
    this(instance,false);
  }
  public ReplicationControllerBuilder(ReplicationController instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReplicationControllerFluent<?> fluent;
  Boolean validationEnabled;
  public ReplicationController build() {
    ReplicationController buildable = new ReplicationController(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}