package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodDNSConfigBuilder extends PodDNSConfigFluentImpl<PodDNSConfigBuilder> implements VisitableBuilder<PodDNSConfig,PodDNSConfigBuilder>{
  public PodDNSConfigBuilder() {
    this(false);
  }
  public PodDNSConfigBuilder(Boolean validationEnabled) {
    this(new PodDNSConfig(), validationEnabled);
  }
  public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodDNSConfig(), validationEnabled);
  }
  public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent,PodDNSConfig instance) {
    this(fluent, instance, false);
  }
  public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent,PodDNSConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withNameservers(instance.getNameservers());
      fluent.withOptions(instance.getOptions());
      fluent.withSearches(instance.getSearches());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodDNSConfigBuilder(PodDNSConfig instance) {
    this(instance,false);
  }
  public PodDNSConfigBuilder(PodDNSConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withNameservers(instance.getNameservers());
      this.withOptions(instance.getOptions());
      this.withSearches(instance.getSearches());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodDNSConfigFluent<?> fluent;
  Boolean validationEnabled;
  public PodDNSConfig build() {
    PodDNSConfig buildable = new PodDNSConfig(fluent.getNameservers(),fluent.getOptions(),fluent.getSearches());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}