package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeStatusBuilder extends PersistentVolumeStatusFluentImpl<PersistentVolumeStatusBuilder> implements VisitableBuilder<PersistentVolumeStatus,PersistentVolumeStatusBuilder>{
  public PersistentVolumeStatusBuilder() {
    this(false);
  }
  public PersistentVolumeStatusBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeStatus(), validationEnabled);
  }
  public PersistentVolumeStatusBuilder(PersistentVolumeStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeStatusBuilder(PersistentVolumeStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeStatus(), validationEnabled);
  }
  public PersistentVolumeStatusBuilder(PersistentVolumeStatusFluent<?> fluent,PersistentVolumeStatus instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeStatusBuilder(PersistentVolumeStatusFluent<?> fluent,PersistentVolumeStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMessage(instance.getMessage());
      fluent.withPhase(instance.getPhase());
      fluent.withReason(instance.getReason());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeStatusBuilder(PersistentVolumeStatus instance) {
    this(instance,false);
  }
  public PersistentVolumeStatusBuilder(PersistentVolumeStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMessage(instance.getMessage());
      this.withPhase(instance.getPhase());
      this.withReason(instance.getReason());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeStatus build() {
    PersistentVolumeStatus buildable = new PersistentVolumeStatus(fluent.getMessage(),fluent.getPhase(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}