package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;
import java.lang.Deprecated;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.util.List;
import java.util.Collection;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Integer;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PersistentVolumeSpecFluentImpl<A extends PersistentVolumeSpecFluent<A>> extends BaseFluent<A> implements PersistentVolumeSpecFluent<A>{
  public PersistentVolumeSpecFluentImpl() {
  }
  public PersistentVolumeSpecFluentImpl(PersistentVolumeSpec instance) {
    if (instance != null) {
      this.withAccessModes(instance.getAccessModes());
      this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore());
      this.withAzureDisk(instance.getAzureDisk());
      this.withAzureFile(instance.getAzureFile());
      this.withCapacity(instance.getCapacity());
      this.withCephfs(instance.getCephfs());
      this.withCinder(instance.getCinder());
      this.withClaimRef(instance.getClaimRef());
      this.withCsi(instance.getCsi());
      this.withFc(instance.getFc());
      this.withFlexVolume(instance.getFlexVolume());
      this.withFlocker(instance.getFlocker());
      this.withGcePersistentDisk(instance.getGcePersistentDisk());
      this.withGlusterfs(instance.getGlusterfs());
      this.withHostPath(instance.getHostPath());
      this.withIscsi(instance.getIscsi());
      this.withLocal(instance.getLocal());
      this.withMountOptions(instance.getMountOptions());
      this.withNfs(instance.getNfs());
      this.withNodeAffinity(instance.getNodeAffinity());
      this.withPersistentVolumeReclaimPolicy(instance.getPersistentVolumeReclaimPolicy());
      this.withPhotonPersistentDisk(instance.getPhotonPersistentDisk());
      this.withPortworxVolume(instance.getPortworxVolume());
      this.withQuobyte(instance.getQuobyte());
      this.withRbd(instance.getRbd());
      this.withScaleIO(instance.getScaleIO());
      this.withStorageClassName(instance.getStorageClassName());
      this.withStorageos(instance.getStorageos());
      this.withVolumeMode(instance.getVolumeMode());
      this.withVsphereVolume(instance.getVsphereVolume());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> accessModes = new ArrayList<String>();
  private AWSElasticBlockStoreVolumeSourceBuilder awsElasticBlockStore;
  private AzureDiskVolumeSourceBuilder azureDisk;
  private AzureFilePersistentVolumeSourceBuilder azureFile;
  private Map<String,Quantity> capacity;
  private CephFSPersistentVolumeSourceBuilder cephfs;
  private CinderPersistentVolumeSourceBuilder cinder;
  private ObjectReferenceBuilder claimRef;
  private CSIPersistentVolumeSourceBuilder csi;
  private FCVolumeSourceBuilder fc;
  private FlexPersistentVolumeSourceBuilder flexVolume;
  private FlockerVolumeSourceBuilder flocker;
  private GCEPersistentDiskVolumeSourceBuilder gcePersistentDisk;
  private GlusterfsPersistentVolumeSourceBuilder glusterfs;
  private HostPathVolumeSourceBuilder hostPath;
  private ISCSIPersistentVolumeSourceBuilder iscsi;
  private LocalVolumeSourceBuilder local;
  private List<String> mountOptions = new ArrayList<String>();
  private NFSVolumeSourceBuilder nfs;
  private VolumeNodeAffinityBuilder nodeAffinity;
  private String persistentVolumeReclaimPolicy;
  private PhotonPersistentDiskVolumeSourceBuilder photonPersistentDisk;
  private PortworxVolumeSourceBuilder portworxVolume;
  private QuobyteVolumeSourceBuilder quobyte;
  private RBDPersistentVolumeSourceBuilder rbd;
  private ScaleIOPersistentVolumeSourceBuilder scaleIO;
  private String storageClassName;
  private StorageOSPersistentVolumeSourceBuilder storageos;
  private String volumeMode;
  private VsphereVirtualDiskVolumeSourceBuilder vsphereVolume;
  private Map<String,Object> additionalProperties;
  public A addToAccessModes(int index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.add(index, item);
    return (A)this;
  }
  public A setToAccessModes(int index,String item) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    this.accessModes.set(index, item); return (A)this;
  }
  public A addToAccessModes(java.lang.String... items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A addAllToAccessModes(Collection<String> items) {
    if (this.accessModes == null) {this.accessModes = new ArrayList<String>();}
    for (String item : items) {this.accessModes.add(item);} return (A)this;
  }
  public A removeFromAccessModes(java.lang.String... items) {
    for (String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public A removeAllFromAccessModes(Collection<String> items) {
    for (String item : items) {if (this.accessModes!= null){ this.accessModes.remove(item);}} return (A)this;
  }
  public List<String> getAccessModes() {
    return this.accessModes;
  }
  public String getAccessMode(int index) {
    return this.accessModes.get(index);
  }
  public String getFirstAccessMode() {
    return this.accessModes.get(0);
  }
  public String getLastAccessMode() {
    return this.accessModes.get(accessModes.size() - 1);
  }
  public String getMatchingAccessMode(Predicate<String> predicate) {
    for (String item: accessModes) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAccessMode(Predicate<String> predicate) {
    for (String item: accessModes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAccessModes(List<String> accessModes) {
    if (accessModes != null) {this.accessModes = new ArrayList(); for (String item : accessModes){this.addToAccessModes(item);}} else { this.accessModes = null;} return (A) this;
  }
  public A withAccessModes(java.lang.String... accessModes) {
    if (this.accessModes != null) {this.accessModes.clear(); _visitables.remove("accessModes"); }
    if (accessModes != null) {for (String item :accessModes){ this.addToAccessModes(item);}} return (A) this;
  }
  public Boolean hasAccessModes() {
    return accessModes != null && !accessModes.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildAwsElasticBlockStore instead.
   * @return The buildable object.
   */
  @Deprecated
  public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore() {
    return this.awsElasticBlockStore!=null ?this.awsElasticBlockStore.build():null;
  }
  public AWSElasticBlockStoreVolumeSource buildAwsElasticBlockStore() {
    return this.awsElasticBlockStore!=null ?this.awsElasticBlockStore.build():null;
  }
  public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore) {
    _visitables.get("awsElasticBlockStore").remove(this.awsElasticBlockStore);
    if (awsElasticBlockStore!=null){ this.awsElasticBlockStore= new AWSElasticBlockStoreVolumeSourceBuilder(awsElasticBlockStore); _visitables.get("awsElasticBlockStore").add(this.awsElasticBlockStore);} else { this.awsElasticBlockStore = null; _visitables.get("awsElasticBlockStore").remove(this.awsElasticBlockStore); } return (A) this;
  }
  public Boolean hasAwsElasticBlockStore() {
    return this.awsElasticBlockStore != null;
  }
  public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID) {
    return (A)withAwsElasticBlockStore(new AWSElasticBlockStoreVolumeSource(fsType, partition, readOnly, volumeID));
  }
  public PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore() {
    return new PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore());
  }
  public PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore() {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): new AWSElasticBlockStoreVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item) {
    return withNewAwsElasticBlockStoreLike(getAwsElasticBlockStore() != null ? getAwsElasticBlockStore(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzureDisk instead.
   * @return The buildable object.
   */
  @Deprecated
  public AzureDiskVolumeSource getAzureDisk() {
    return this.azureDisk!=null ?this.azureDisk.build():null;
  }
  public AzureDiskVolumeSource buildAzureDisk() {
    return this.azureDisk!=null ?this.azureDisk.build():null;
  }
  public A withAzureDisk(AzureDiskVolumeSource azureDisk) {
    _visitables.get("azureDisk").remove(this.azureDisk);
    if (azureDisk!=null){ this.azureDisk= new AzureDiskVolumeSourceBuilder(azureDisk); _visitables.get("azureDisk").add(this.azureDisk);} else { this.azureDisk = null; _visitables.get("azureDisk").remove(this.azureDisk); } return (A) this;
  }
  public Boolean hasAzureDisk() {
    return this.azureDisk != null;
  }
  public PersistentVolumeSpecFluentImpl.AzureDiskNested<A> withNewAzureDisk() {
    return new PersistentVolumeSpecFluentImpl.AzureDiskNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.AzureDiskNested<A> withNewAzureDiskLike(AzureDiskVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.AzureDiskNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.AzureDiskNested<A> editAzureDisk() {
    return withNewAzureDiskLike(getAzureDisk());
  }
  public PersistentVolumeSpecFluentImpl.AzureDiskNested<A> editOrNewAzureDisk() {
    return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): new AzureDiskVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.AzureDiskNested<A> editOrNewAzureDiskLike(AzureDiskVolumeSource item) {
    return withNewAzureDiskLike(getAzureDisk() != null ? getAzureDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildAzureFile instead.
   * @return The buildable object.
   */
  @Deprecated
  public AzureFilePersistentVolumeSource getAzureFile() {
    return this.azureFile!=null ?this.azureFile.build():null;
  }
  public AzureFilePersistentVolumeSource buildAzureFile() {
    return this.azureFile!=null ?this.azureFile.build():null;
  }
  public A withAzureFile(AzureFilePersistentVolumeSource azureFile) {
    _visitables.get("azureFile").remove(this.azureFile);
    if (azureFile!=null){ this.azureFile= new AzureFilePersistentVolumeSourceBuilder(azureFile); _visitables.get("azureFile").add(this.azureFile);} else { this.azureFile = null; _visitables.get("azureFile").remove(this.azureFile); } return (A) this;
  }
  public Boolean hasAzureFile() {
    return this.azureFile != null;
  }
  public A withNewAzureFile(Boolean readOnly,String secretName,String secretNamespace,String shareName) {
    return (A)withAzureFile(new AzureFilePersistentVolumeSource(readOnly, secretName, secretNamespace, shareName));
  }
  public PersistentVolumeSpecFluentImpl.AzureFileNested<A> withNewAzureFile() {
    return new PersistentVolumeSpecFluentImpl.AzureFileNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.AzureFileNested<A> withNewAzureFileLike(AzureFilePersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.AzureFileNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.AzureFileNested<A> editAzureFile() {
    return withNewAzureFileLike(getAzureFile());
  }
  public PersistentVolumeSpecFluentImpl.AzureFileNested<A> editOrNewAzureFile() {
    return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): new AzureFilePersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.AzureFileNested<A> editOrNewAzureFileLike(AzureFilePersistentVolumeSource item) {
    return withNewAzureFileLike(getAzureFile() != null ? getAzureFile(): item);
  }
  public A addToCapacity(String key,Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(Map<String,Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(Map<String,Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(Map<String,Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new LinkedHashMap(capacity);} return (A) this;
  }
  public Boolean hasCapacity() {
    return this.capacity != null;
  }
  
  /**
   * This method has been deprecated, please use method buildCephfs instead.
   * @return The buildable object.
   */
  @Deprecated
  public CephFSPersistentVolumeSource getCephfs() {
    return this.cephfs!=null ?this.cephfs.build():null;
  }
  public CephFSPersistentVolumeSource buildCephfs() {
    return this.cephfs!=null ?this.cephfs.build():null;
  }
  public A withCephfs(CephFSPersistentVolumeSource cephfs) {
    _visitables.get("cephfs").remove(this.cephfs);
    if (cephfs!=null){ this.cephfs= new CephFSPersistentVolumeSourceBuilder(cephfs); _visitables.get("cephfs").add(this.cephfs);} else { this.cephfs = null; _visitables.get("cephfs").remove(this.cephfs); } return (A) this;
  }
  public Boolean hasCephfs() {
    return this.cephfs != null;
  }
  public PersistentVolumeSpecFluentImpl.CephfsNested<A> withNewCephfs() {
    return new PersistentVolumeSpecFluentImpl.CephfsNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.CephfsNested<A> withNewCephfsLike(CephFSPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.CephfsNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.CephfsNested<A> editCephfs() {
    return withNewCephfsLike(getCephfs());
  }
  public PersistentVolumeSpecFluentImpl.CephfsNested<A> editOrNewCephfs() {
    return withNewCephfsLike(getCephfs() != null ? getCephfs(): new CephFSPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.CephfsNested<A> editOrNewCephfsLike(CephFSPersistentVolumeSource item) {
    return withNewCephfsLike(getCephfs() != null ? getCephfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCinder instead.
   * @return The buildable object.
   */
  @Deprecated
  public CinderPersistentVolumeSource getCinder() {
    return this.cinder!=null ?this.cinder.build():null;
  }
  public CinderPersistentVolumeSource buildCinder() {
    return this.cinder!=null ?this.cinder.build():null;
  }
  public A withCinder(CinderPersistentVolumeSource cinder) {
    _visitables.get("cinder").remove(this.cinder);
    if (cinder!=null){ this.cinder= new CinderPersistentVolumeSourceBuilder(cinder); _visitables.get("cinder").add(this.cinder);} else { this.cinder = null; _visitables.get("cinder").remove(this.cinder); } return (A) this;
  }
  public Boolean hasCinder() {
    return this.cinder != null;
  }
  public PersistentVolumeSpecFluentImpl.CinderNested<A> withNewCinder() {
    return new PersistentVolumeSpecFluentImpl.CinderNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.CinderNested<A> withNewCinderLike(CinderPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.CinderNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.CinderNested<A> editCinder() {
    return withNewCinderLike(getCinder());
  }
  public PersistentVolumeSpecFluentImpl.CinderNested<A> editOrNewCinder() {
    return withNewCinderLike(getCinder() != null ? getCinder(): new CinderPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.CinderNested<A> editOrNewCinderLike(CinderPersistentVolumeSource item) {
    return withNewCinderLike(getCinder() != null ? getCinder(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildClaimRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getClaimRef() {
    return this.claimRef!=null ?this.claimRef.build():null;
  }
  public ObjectReference buildClaimRef() {
    return this.claimRef!=null ?this.claimRef.build():null;
  }
  public A withClaimRef(ObjectReference claimRef) {
    _visitables.get("claimRef").remove(this.claimRef);
    if (claimRef!=null){ this.claimRef= new ObjectReferenceBuilder(claimRef); _visitables.get("claimRef").add(this.claimRef);} else { this.claimRef = null; _visitables.get("claimRef").remove(this.claimRef); } return (A) this;
  }
  public Boolean hasClaimRef() {
    return this.claimRef != null;
  }
  public PersistentVolumeSpecFluentImpl.ClaimRefNested<A> withNewClaimRef() {
    return new PersistentVolumeSpecFluentImpl.ClaimRefNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item) {
    return new PersistentVolumeSpecFluentImpl.ClaimRefNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.ClaimRefNested<A> editClaimRef() {
    return withNewClaimRefLike(getClaimRef());
  }
  public PersistentVolumeSpecFluentImpl.ClaimRefNested<A> editOrNewClaimRef() {
    return withNewClaimRefLike(getClaimRef() != null ? getClaimRef(): new ObjectReferenceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.ClaimRefNested<A> editOrNewClaimRefLike(ObjectReference item) {
    return withNewClaimRefLike(getClaimRef() != null ? getClaimRef(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildCsi instead.
   * @return The buildable object.
   */
  @Deprecated
  public CSIPersistentVolumeSource getCsi() {
    return this.csi!=null ?this.csi.build():null;
  }
  public CSIPersistentVolumeSource buildCsi() {
    return this.csi!=null ?this.csi.build():null;
  }
  public A withCsi(CSIPersistentVolumeSource csi) {
    _visitables.get("csi").remove(this.csi);
    if (csi!=null){ this.csi= new CSIPersistentVolumeSourceBuilder(csi); _visitables.get("csi").add(this.csi);} else { this.csi = null; _visitables.get("csi").remove(this.csi); } return (A) this;
  }
  public Boolean hasCsi() {
    return this.csi != null;
  }
  public PersistentVolumeSpecFluentImpl.CsiNested<A> withNewCsi() {
    return new PersistentVolumeSpecFluentImpl.CsiNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.CsiNested<A> withNewCsiLike(CSIPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.CsiNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.CsiNested<A> editCsi() {
    return withNewCsiLike(getCsi());
  }
  public PersistentVolumeSpecFluentImpl.CsiNested<A> editOrNewCsi() {
    return withNewCsiLike(getCsi() != null ? getCsi(): new CSIPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.CsiNested<A> editOrNewCsiLike(CSIPersistentVolumeSource item) {
    return withNewCsiLike(getCsi() != null ? getCsi(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFc instead.
   * @return The buildable object.
   */
  @Deprecated
  public FCVolumeSource getFc() {
    return this.fc!=null ?this.fc.build():null;
  }
  public FCVolumeSource buildFc() {
    return this.fc!=null ?this.fc.build():null;
  }
  public A withFc(FCVolumeSource fc) {
    _visitables.get("fc").remove(this.fc);
    if (fc!=null){ this.fc= new FCVolumeSourceBuilder(fc); _visitables.get("fc").add(this.fc);} else { this.fc = null; _visitables.get("fc").remove(this.fc); } return (A) this;
  }
  public Boolean hasFc() {
    return this.fc != null;
  }
  public PersistentVolumeSpecFluentImpl.FcNested<A> withNewFc() {
    return new PersistentVolumeSpecFluentImpl.FcNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.FcNested<A> withNewFcLike(FCVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.FcNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.FcNested<A> editFc() {
    return withNewFcLike(getFc());
  }
  public PersistentVolumeSpecFluentImpl.FcNested<A> editOrNewFc() {
    return withNewFcLike(getFc() != null ? getFc(): new FCVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.FcNested<A> editOrNewFcLike(FCVolumeSource item) {
    return withNewFcLike(getFc() != null ? getFc(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFlexVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public FlexPersistentVolumeSource getFlexVolume() {
    return this.flexVolume!=null ?this.flexVolume.build():null;
  }
  public FlexPersistentVolumeSource buildFlexVolume() {
    return this.flexVolume!=null ?this.flexVolume.build():null;
  }
  public A withFlexVolume(FlexPersistentVolumeSource flexVolume) {
    _visitables.get("flexVolume").remove(this.flexVolume);
    if (flexVolume!=null){ this.flexVolume= new FlexPersistentVolumeSourceBuilder(flexVolume); _visitables.get("flexVolume").add(this.flexVolume);} else { this.flexVolume = null; _visitables.get("flexVolume").remove(this.flexVolume); } return (A) this;
  }
  public Boolean hasFlexVolume() {
    return this.flexVolume != null;
  }
  public PersistentVolumeSpecFluentImpl.FlexVolumeNested<A> withNewFlexVolume() {
    return new PersistentVolumeSpecFluentImpl.FlexVolumeNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.FlexVolumeNested<A> withNewFlexVolumeLike(FlexPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.FlexVolumeNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.FlexVolumeNested<A> editFlexVolume() {
    return withNewFlexVolumeLike(getFlexVolume());
  }
  public PersistentVolumeSpecFluentImpl.FlexVolumeNested<A> editOrNewFlexVolume() {
    return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): new FlexPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexPersistentVolumeSource item) {
    return withNewFlexVolumeLike(getFlexVolume() != null ? getFlexVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildFlocker instead.
   * @return The buildable object.
   */
  @Deprecated
  public FlockerVolumeSource getFlocker() {
    return this.flocker!=null ?this.flocker.build():null;
  }
  public FlockerVolumeSource buildFlocker() {
    return this.flocker!=null ?this.flocker.build():null;
  }
  public A withFlocker(FlockerVolumeSource flocker) {
    _visitables.get("flocker").remove(this.flocker);
    if (flocker!=null){ this.flocker= new FlockerVolumeSourceBuilder(flocker); _visitables.get("flocker").add(this.flocker);} else { this.flocker = null; _visitables.get("flocker").remove(this.flocker); } return (A) this;
  }
  public Boolean hasFlocker() {
    return this.flocker != null;
  }
  public A withNewFlocker(String datasetName,String datasetUUID) {
    return (A)withFlocker(new FlockerVolumeSource(datasetName, datasetUUID));
  }
  public PersistentVolumeSpecFluentImpl.FlockerNested<A> withNewFlocker() {
    return new PersistentVolumeSpecFluentImpl.FlockerNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.FlockerNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.FlockerNested<A> editFlocker() {
    return withNewFlockerLike(getFlocker());
  }
  public PersistentVolumeSpecFluentImpl.FlockerNested<A> editOrNewFlocker() {
    return withNewFlockerLike(getFlocker() != null ? getFlocker(): new FlockerVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item) {
    return withNewFlockerLike(getFlocker() != null ? getFlocker(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGcePersistentDisk instead.
   * @return The buildable object.
   */
  @Deprecated
  public GCEPersistentDiskVolumeSource getGcePersistentDisk() {
    return this.gcePersistentDisk!=null ?this.gcePersistentDisk.build():null;
  }
  public GCEPersistentDiskVolumeSource buildGcePersistentDisk() {
    return this.gcePersistentDisk!=null ?this.gcePersistentDisk.build():null;
  }
  public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk) {
    _visitables.get("gcePersistentDisk").remove(this.gcePersistentDisk);
    if (gcePersistentDisk!=null){ this.gcePersistentDisk= new GCEPersistentDiskVolumeSourceBuilder(gcePersistentDisk); _visitables.get("gcePersistentDisk").add(this.gcePersistentDisk);} else { this.gcePersistentDisk = null; _visitables.get("gcePersistentDisk").remove(this.gcePersistentDisk); } return (A) this;
  }
  public Boolean hasGcePersistentDisk() {
    return this.gcePersistentDisk != null;
  }
  public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly) {
    return (A)withGcePersistentDisk(new GCEPersistentDiskVolumeSource(fsType, partition, pdName, readOnly));
  }
  public PersistentVolumeSpecFluentImpl.GcePersistentDiskNested<A> withNewGcePersistentDisk() {
    return new PersistentVolumeSpecFluentImpl.GcePersistentDiskNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.GcePersistentDiskNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.GcePersistentDiskNested<A> editGcePersistentDisk() {
    return withNewGcePersistentDiskLike(getGcePersistentDisk());
  }
  public PersistentVolumeSpecFluentImpl.GcePersistentDiskNested<A> editOrNewGcePersistentDisk() {
    return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): new GCEPersistentDiskVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item) {
    return withNewGcePersistentDiskLike(getGcePersistentDisk() != null ? getGcePersistentDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildGlusterfs instead.
   * @return The buildable object.
   */
  @Deprecated
  public GlusterfsPersistentVolumeSource getGlusterfs() {
    return this.glusterfs!=null ?this.glusterfs.build():null;
  }
  public GlusterfsPersistentVolumeSource buildGlusterfs() {
    return this.glusterfs!=null ?this.glusterfs.build():null;
  }
  public A withGlusterfs(GlusterfsPersistentVolumeSource glusterfs) {
    _visitables.get("glusterfs").remove(this.glusterfs);
    if (glusterfs!=null){ this.glusterfs= new GlusterfsPersistentVolumeSourceBuilder(glusterfs); _visitables.get("glusterfs").add(this.glusterfs);} else { this.glusterfs = null; _visitables.get("glusterfs").remove(this.glusterfs); } return (A) this;
  }
  public Boolean hasGlusterfs() {
    return this.glusterfs != null;
  }
  public A withNewGlusterfs(String endpoints,String endpointsNamespace,String path,Boolean readOnly) {
    return (A)withGlusterfs(new GlusterfsPersistentVolumeSource(endpoints, endpointsNamespace, path, readOnly));
  }
  public PersistentVolumeSpecFluentImpl.GlusterfsNested<A> withNewGlusterfs() {
    return new PersistentVolumeSpecFluentImpl.GlusterfsNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.GlusterfsNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.GlusterfsNested<A> editGlusterfs() {
    return withNewGlusterfsLike(getGlusterfs());
  }
  public PersistentVolumeSpecFluentImpl.GlusterfsNested<A> editOrNewGlusterfs() {
    return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): new GlusterfsPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsPersistentVolumeSource item) {
    return withNewGlusterfsLike(getGlusterfs() != null ? getGlusterfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildHostPath instead.
   * @return The buildable object.
   */
  @Deprecated
  public HostPathVolumeSource getHostPath() {
    return this.hostPath!=null ?this.hostPath.build():null;
  }
  public HostPathVolumeSource buildHostPath() {
    return this.hostPath!=null ?this.hostPath.build():null;
  }
  public A withHostPath(HostPathVolumeSource hostPath) {
    _visitables.get("hostPath").remove(this.hostPath);
    if (hostPath!=null){ this.hostPath= new HostPathVolumeSourceBuilder(hostPath); _visitables.get("hostPath").add(this.hostPath);} else { this.hostPath = null; _visitables.get("hostPath").remove(this.hostPath); } return (A) this;
  }
  public Boolean hasHostPath() {
    return this.hostPath != null;
  }
  public A withNewHostPath(String path,String type) {
    return (A)withHostPath(new HostPathVolumeSource(path, type));
  }
  public PersistentVolumeSpecFluentImpl.HostPathNested<A> withNewHostPath() {
    return new PersistentVolumeSpecFluentImpl.HostPathNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.HostPathNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.HostPathNested<A> editHostPath() {
    return withNewHostPathLike(getHostPath());
  }
  public PersistentVolumeSpecFluentImpl.HostPathNested<A> editOrNewHostPath() {
    return withNewHostPathLike(getHostPath() != null ? getHostPath(): new HostPathVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item) {
    return withNewHostPathLike(getHostPath() != null ? getHostPath(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildIscsi instead.
   * @return The buildable object.
   */
  @Deprecated
  public ISCSIPersistentVolumeSource getIscsi() {
    return this.iscsi!=null ?this.iscsi.build():null;
  }
  public ISCSIPersistentVolumeSource buildIscsi() {
    return this.iscsi!=null ?this.iscsi.build():null;
  }
  public A withIscsi(ISCSIPersistentVolumeSource iscsi) {
    _visitables.get("iscsi").remove(this.iscsi);
    if (iscsi!=null){ this.iscsi= new ISCSIPersistentVolumeSourceBuilder(iscsi); _visitables.get("iscsi").add(this.iscsi);} else { this.iscsi = null; _visitables.get("iscsi").remove(this.iscsi); } return (A) this;
  }
  public Boolean hasIscsi() {
    return this.iscsi != null;
  }
  public PersistentVolumeSpecFluentImpl.IscsiNested<A> withNewIscsi() {
    return new PersistentVolumeSpecFluentImpl.IscsiNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.IscsiNested<A> withNewIscsiLike(ISCSIPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.IscsiNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.IscsiNested<A> editIscsi() {
    return withNewIscsiLike(getIscsi());
  }
  public PersistentVolumeSpecFluentImpl.IscsiNested<A> editOrNewIscsi() {
    return withNewIscsiLike(getIscsi() != null ? getIscsi(): new ISCSIPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.IscsiNested<A> editOrNewIscsiLike(ISCSIPersistentVolumeSource item) {
    return withNewIscsiLike(getIscsi() != null ? getIscsi(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLocal instead.
   * @return The buildable object.
   */
  @Deprecated
  public LocalVolumeSource getLocal() {
    return this.local!=null ?this.local.build():null;
  }
  public LocalVolumeSource buildLocal() {
    return this.local!=null ?this.local.build():null;
  }
  public A withLocal(LocalVolumeSource local) {
    _visitables.get("local").remove(this.local);
    if (local!=null){ this.local= new LocalVolumeSourceBuilder(local); _visitables.get("local").add(this.local);} else { this.local = null; _visitables.get("local").remove(this.local); } return (A) this;
  }
  public Boolean hasLocal() {
    return this.local != null;
  }
  public A withNewLocal(String fsType,String path) {
    return (A)withLocal(new LocalVolumeSource(fsType, path));
  }
  public PersistentVolumeSpecFluentImpl.LocalNested<A> withNewLocal() {
    return new PersistentVolumeSpecFluentImpl.LocalNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.LocalNested<A> withNewLocalLike(LocalVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.LocalNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.LocalNested<A> editLocal() {
    return withNewLocalLike(getLocal());
  }
  public PersistentVolumeSpecFluentImpl.LocalNested<A> editOrNewLocal() {
    return withNewLocalLike(getLocal() != null ? getLocal(): new LocalVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.LocalNested<A> editOrNewLocalLike(LocalVolumeSource item) {
    return withNewLocalLike(getLocal() != null ? getLocal(): item);
  }
  public A addToMountOptions(int index,String item) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    this.mountOptions.add(index, item);
    return (A)this;
  }
  public A setToMountOptions(int index,String item) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    this.mountOptions.set(index, item); return (A)this;
  }
  public A addToMountOptions(java.lang.String... items) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    for (String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  public A addAllToMountOptions(Collection<String> items) {
    if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
    for (String item : items) {this.mountOptions.add(item);} return (A)this;
  }
  public A removeFromMountOptions(java.lang.String... items) {
    for (String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
  }
  public A removeAllFromMountOptions(Collection<String> items) {
    for (String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
  }
  public List<String> getMountOptions() {
    return this.mountOptions;
  }
  public String getMountOption(int index) {
    return this.mountOptions.get(index);
  }
  public String getFirstMountOption() {
    return this.mountOptions.get(0);
  }
  public String getLastMountOption() {
    return this.mountOptions.get(mountOptions.size() - 1);
  }
  public String getMatchingMountOption(Predicate<String> predicate) {
    for (String item: mountOptions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMountOption(Predicate<String> predicate) {
    for (String item: mountOptions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMountOptions(List<String> mountOptions) {
    if (mountOptions != null) {this.mountOptions = new ArrayList(); for (String item : mountOptions){this.addToMountOptions(item);}} else { this.mountOptions = null;} return (A) this;
  }
  public A withMountOptions(java.lang.String... mountOptions) {
    if (this.mountOptions != null) {this.mountOptions.clear(); _visitables.remove("mountOptions"); }
    if (mountOptions != null) {for (String item :mountOptions){ this.addToMountOptions(item);}} return (A) this;
  }
  public Boolean hasMountOptions() {
    return mountOptions != null && !mountOptions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildNfs instead.
   * @return The buildable object.
   */
  @Deprecated
  public NFSVolumeSource getNfs() {
    return this.nfs!=null ?this.nfs.build():null;
  }
  public NFSVolumeSource buildNfs() {
    return this.nfs!=null ?this.nfs.build():null;
  }
  public A withNfs(NFSVolumeSource nfs) {
    _visitables.get("nfs").remove(this.nfs);
    if (nfs!=null){ this.nfs= new NFSVolumeSourceBuilder(nfs); _visitables.get("nfs").add(this.nfs);} else { this.nfs = null; _visitables.get("nfs").remove(this.nfs); } return (A) this;
  }
  public Boolean hasNfs() {
    return this.nfs != null;
  }
  public A withNewNfs(String path,Boolean readOnly,String server) {
    return (A)withNfs(new NFSVolumeSource(path, readOnly, server));
  }
  public PersistentVolumeSpecFluentImpl.NfsNested<A> withNewNfs() {
    return new PersistentVolumeSpecFluentImpl.NfsNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.NfsNested<A> withNewNfsLike(NFSVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.NfsNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.NfsNested<A> editNfs() {
    return withNewNfsLike(getNfs());
  }
  public PersistentVolumeSpecFluentImpl.NfsNested<A> editOrNewNfs() {
    return withNewNfsLike(getNfs() != null ? getNfs(): new NFSVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item) {
    return withNewNfsLike(getNfs() != null ? getNfs(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildNodeAffinity instead.
   * @return The buildable object.
   */
  @Deprecated
  public VolumeNodeAffinity getNodeAffinity() {
    return this.nodeAffinity!=null ?this.nodeAffinity.build():null;
  }
  public VolumeNodeAffinity buildNodeAffinity() {
    return this.nodeAffinity!=null ?this.nodeAffinity.build():null;
  }
  public A withNodeAffinity(VolumeNodeAffinity nodeAffinity) {
    _visitables.get("nodeAffinity").remove(this.nodeAffinity);
    if (nodeAffinity!=null){ this.nodeAffinity= new VolumeNodeAffinityBuilder(nodeAffinity); _visitables.get("nodeAffinity").add(this.nodeAffinity);} else { this.nodeAffinity = null; _visitables.get("nodeAffinity").remove(this.nodeAffinity); } return (A) this;
  }
  public Boolean hasNodeAffinity() {
    return this.nodeAffinity != null;
  }
  public PersistentVolumeSpecFluentImpl.NodeAffinityNested<A> withNewNodeAffinity() {
    return new PersistentVolumeSpecFluentImpl.NodeAffinityNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.NodeAffinityNested<A> withNewNodeAffinityLike(VolumeNodeAffinity item) {
    return new PersistentVolumeSpecFluentImpl.NodeAffinityNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.NodeAffinityNested<A> editNodeAffinity() {
    return withNewNodeAffinityLike(getNodeAffinity());
  }
  public PersistentVolumeSpecFluentImpl.NodeAffinityNested<A> editOrNewNodeAffinity() {
    return withNewNodeAffinityLike(getNodeAffinity() != null ? getNodeAffinity(): new VolumeNodeAffinityBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.NodeAffinityNested<A> editOrNewNodeAffinityLike(VolumeNodeAffinity item) {
    return withNewNodeAffinityLike(getNodeAffinity() != null ? getNodeAffinity(): item);
  }
  public String getPersistentVolumeReclaimPolicy() {
    return this.persistentVolumeReclaimPolicy;
  }
  public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy) {
    this.persistentVolumeReclaimPolicy=persistentVolumeReclaimPolicy; return (A) this;
  }
  public Boolean hasPersistentVolumeReclaimPolicy() {
    return this.persistentVolumeReclaimPolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPhotonPersistentDisk instead.
   * @return The buildable object.
   */
  @Deprecated
  public PhotonPersistentDiskVolumeSource getPhotonPersistentDisk() {
    return this.photonPersistentDisk!=null ?this.photonPersistentDisk.build():null;
  }
  public PhotonPersistentDiskVolumeSource buildPhotonPersistentDisk() {
    return this.photonPersistentDisk!=null ?this.photonPersistentDisk.build():null;
  }
  public A withPhotonPersistentDisk(PhotonPersistentDiskVolumeSource photonPersistentDisk) {
    _visitables.get("photonPersistentDisk").remove(this.photonPersistentDisk);
    if (photonPersistentDisk!=null){ this.photonPersistentDisk= new PhotonPersistentDiskVolumeSourceBuilder(photonPersistentDisk); _visitables.get("photonPersistentDisk").add(this.photonPersistentDisk);} else { this.photonPersistentDisk = null; _visitables.get("photonPersistentDisk").remove(this.photonPersistentDisk); } return (A) this;
  }
  public Boolean hasPhotonPersistentDisk() {
    return this.photonPersistentDisk != null;
  }
  public A withNewPhotonPersistentDisk(String fsType,String pdID) {
    return (A)withPhotonPersistentDisk(new PhotonPersistentDiskVolumeSource(fsType, pdID));
  }
  public PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNested<A> withNewPhotonPersistentDisk() {
    return new PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNested<A> withNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNested<A> editPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk());
  }
  public PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDisk() {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): new PhotonPersistentDiskVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNested<A> editOrNewPhotonPersistentDiskLike(PhotonPersistentDiskVolumeSource item) {
    return withNewPhotonPersistentDiskLike(getPhotonPersistentDisk() != null ? getPhotonPersistentDisk(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPortworxVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public PortworxVolumeSource getPortworxVolume() {
    return this.portworxVolume!=null ?this.portworxVolume.build():null;
  }
  public PortworxVolumeSource buildPortworxVolume() {
    return this.portworxVolume!=null ?this.portworxVolume.build():null;
  }
  public A withPortworxVolume(PortworxVolumeSource portworxVolume) {
    _visitables.get("portworxVolume").remove(this.portworxVolume);
    if (portworxVolume!=null){ this.portworxVolume= new PortworxVolumeSourceBuilder(portworxVolume); _visitables.get("portworxVolume").add(this.portworxVolume);} else { this.portworxVolume = null; _visitables.get("portworxVolume").remove(this.portworxVolume); } return (A) this;
  }
  public Boolean hasPortworxVolume() {
    return this.portworxVolume != null;
  }
  public A withNewPortworxVolume(String fsType,Boolean readOnly,String volumeID) {
    return (A)withPortworxVolume(new PortworxVolumeSource(fsType, readOnly, volumeID));
  }
  public PersistentVolumeSpecFluentImpl.PortworxVolumeNested<A> withNewPortworxVolume() {
    return new PersistentVolumeSpecFluentImpl.PortworxVolumeNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.PortworxVolumeNested<A> withNewPortworxVolumeLike(PortworxVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.PortworxVolumeNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.PortworxVolumeNested<A> editPortworxVolume() {
    return withNewPortworxVolumeLike(getPortworxVolume());
  }
  public PersistentVolumeSpecFluentImpl.PortworxVolumeNested<A> editOrNewPortworxVolume() {
    return withNewPortworxVolumeLike(getPortworxVolume() != null ? getPortworxVolume(): new PortworxVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.PortworxVolumeNested<A> editOrNewPortworxVolumeLike(PortworxVolumeSource item) {
    return withNewPortworxVolumeLike(getPortworxVolume() != null ? getPortworxVolume(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildQuobyte instead.
   * @return The buildable object.
   */
  @Deprecated
  public QuobyteVolumeSource getQuobyte() {
    return this.quobyte!=null ?this.quobyte.build():null;
  }
  public QuobyteVolumeSource buildQuobyte() {
    return this.quobyte!=null ?this.quobyte.build():null;
  }
  public A withQuobyte(QuobyteVolumeSource quobyte) {
    _visitables.get("quobyte").remove(this.quobyte);
    if (quobyte!=null){ this.quobyte= new QuobyteVolumeSourceBuilder(quobyte); _visitables.get("quobyte").add(this.quobyte);} else { this.quobyte = null; _visitables.get("quobyte").remove(this.quobyte); } return (A) this;
  }
  public Boolean hasQuobyte() {
    return this.quobyte != null;
  }
  public PersistentVolumeSpecFluentImpl.QuobyteNested<A> withNewQuobyte() {
    return new PersistentVolumeSpecFluentImpl.QuobyteNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.QuobyteNested<A> withNewQuobyteLike(QuobyteVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.QuobyteNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.QuobyteNested<A> editQuobyte() {
    return withNewQuobyteLike(getQuobyte());
  }
  public PersistentVolumeSpecFluentImpl.QuobyteNested<A> editOrNewQuobyte() {
    return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): new QuobyteVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.QuobyteNested<A> editOrNewQuobyteLike(QuobyteVolumeSource item) {
    return withNewQuobyteLike(getQuobyte() != null ? getQuobyte(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildRbd instead.
   * @return The buildable object.
   */
  @Deprecated
  public RBDPersistentVolumeSource getRbd() {
    return this.rbd!=null ?this.rbd.build():null;
  }
  public RBDPersistentVolumeSource buildRbd() {
    return this.rbd!=null ?this.rbd.build():null;
  }
  public A withRbd(RBDPersistentVolumeSource rbd) {
    _visitables.get("rbd").remove(this.rbd);
    if (rbd!=null){ this.rbd= new RBDPersistentVolumeSourceBuilder(rbd); _visitables.get("rbd").add(this.rbd);} else { this.rbd = null; _visitables.get("rbd").remove(this.rbd); } return (A) this;
  }
  public Boolean hasRbd() {
    return this.rbd != null;
  }
  public PersistentVolumeSpecFluentImpl.RbdNested<A> withNewRbd() {
    return new PersistentVolumeSpecFluentImpl.RbdNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.RbdNested<A> withNewRbdLike(RBDPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.RbdNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.RbdNested<A> editRbd() {
    return withNewRbdLike(getRbd());
  }
  public PersistentVolumeSpecFluentImpl.RbdNested<A> editOrNewRbd() {
    return withNewRbdLike(getRbd() != null ? getRbd(): new RBDPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.RbdNested<A> editOrNewRbdLike(RBDPersistentVolumeSource item) {
    return withNewRbdLike(getRbd() != null ? getRbd(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildScaleIO instead.
   * @return The buildable object.
   */
  @Deprecated
  public ScaleIOPersistentVolumeSource getScaleIO() {
    return this.scaleIO!=null ?this.scaleIO.build():null;
  }
  public ScaleIOPersistentVolumeSource buildScaleIO() {
    return this.scaleIO!=null ?this.scaleIO.build():null;
  }
  public A withScaleIO(ScaleIOPersistentVolumeSource scaleIO) {
    _visitables.get("scaleIO").remove(this.scaleIO);
    if (scaleIO!=null){ this.scaleIO= new ScaleIOPersistentVolumeSourceBuilder(scaleIO); _visitables.get("scaleIO").add(this.scaleIO);} else { this.scaleIO = null; _visitables.get("scaleIO").remove(this.scaleIO); } return (A) this;
  }
  public Boolean hasScaleIO() {
    return this.scaleIO != null;
  }
  public PersistentVolumeSpecFluentImpl.ScaleIONested<A> withNewScaleIO() {
    return new PersistentVolumeSpecFluentImpl.ScaleIONestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.ScaleIONested<A> withNewScaleIOLike(ScaleIOPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.ScaleIONestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.ScaleIONested<A> editScaleIO() {
    return withNewScaleIOLike(getScaleIO());
  }
  public PersistentVolumeSpecFluentImpl.ScaleIONested<A> editOrNewScaleIO() {
    return withNewScaleIOLike(getScaleIO() != null ? getScaleIO(): new ScaleIOPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.ScaleIONested<A> editOrNewScaleIOLike(ScaleIOPersistentVolumeSource item) {
    return withNewScaleIOLike(getScaleIO() != null ? getScaleIO(): item);
  }
  public String getStorageClassName() {
    return this.storageClassName;
  }
  public A withStorageClassName(String storageClassName) {
    this.storageClassName=storageClassName; return (A) this;
  }
  public Boolean hasStorageClassName() {
    return this.storageClassName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildStorageos instead.
   * @return The buildable object.
   */
  @Deprecated
  public StorageOSPersistentVolumeSource getStorageos() {
    return this.storageos!=null ?this.storageos.build():null;
  }
  public StorageOSPersistentVolumeSource buildStorageos() {
    return this.storageos!=null ?this.storageos.build():null;
  }
  public A withStorageos(StorageOSPersistentVolumeSource storageos) {
    _visitables.get("storageos").remove(this.storageos);
    if (storageos!=null){ this.storageos= new StorageOSPersistentVolumeSourceBuilder(storageos); _visitables.get("storageos").add(this.storageos);} else { this.storageos = null; _visitables.get("storageos").remove(this.storageos); } return (A) this;
  }
  public Boolean hasStorageos() {
    return this.storageos != null;
  }
  public PersistentVolumeSpecFluentImpl.StorageosNested<A> withNewStorageos() {
    return new PersistentVolumeSpecFluentImpl.StorageosNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.StorageosNested<A> withNewStorageosLike(StorageOSPersistentVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.StorageosNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.StorageosNested<A> editStorageos() {
    return withNewStorageosLike(getStorageos());
  }
  public PersistentVolumeSpecFluentImpl.StorageosNested<A> editOrNewStorageos() {
    return withNewStorageosLike(getStorageos() != null ? getStorageos(): new StorageOSPersistentVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.StorageosNested<A> editOrNewStorageosLike(StorageOSPersistentVolumeSource item) {
    return withNewStorageosLike(getStorageos() != null ? getStorageos(): item);
  }
  public String getVolumeMode() {
    return this.volumeMode;
  }
  public A withVolumeMode(String volumeMode) {
    this.volumeMode=volumeMode; return (A) this;
  }
  public Boolean hasVolumeMode() {
    return this.volumeMode != null;
  }
  
  /**
   * This method has been deprecated, please use method buildVsphereVolume instead.
   * @return The buildable object.
   */
  @Deprecated
  public VsphereVirtualDiskVolumeSource getVsphereVolume() {
    return this.vsphereVolume!=null ?this.vsphereVolume.build():null;
  }
  public VsphereVirtualDiskVolumeSource buildVsphereVolume() {
    return this.vsphereVolume!=null ?this.vsphereVolume.build():null;
  }
  public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume) {
    _visitables.get("vsphereVolume").remove(this.vsphereVolume);
    if (vsphereVolume!=null){ this.vsphereVolume= new VsphereVirtualDiskVolumeSourceBuilder(vsphereVolume); _visitables.get("vsphereVolume").add(this.vsphereVolume);} else { this.vsphereVolume = null; _visitables.get("vsphereVolume").remove(this.vsphereVolume); } return (A) this;
  }
  public Boolean hasVsphereVolume() {
    return this.vsphereVolume != null;
  }
  public A withNewVsphereVolume(String fsType,String storagePolicyID,String storagePolicyName,String volumePath) {
    return (A)withVsphereVolume(new VsphereVirtualDiskVolumeSource(fsType, storagePolicyID, storagePolicyName, volumePath));
  }
  public PersistentVolumeSpecFluentImpl.VsphereVolumeNested<A> withNewVsphereVolume() {
    return new PersistentVolumeSpecFluentImpl.VsphereVolumeNestedImpl();
  }
  public PersistentVolumeSpecFluentImpl.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
    return new PersistentVolumeSpecFluentImpl.VsphereVolumeNestedImpl(item);
  }
  public PersistentVolumeSpecFluentImpl.VsphereVolumeNested<A> editVsphereVolume() {
    return withNewVsphereVolumeLike(getVsphereVolume());
  }
  public PersistentVolumeSpecFluentImpl.VsphereVolumeNested<A> editOrNewVsphereVolume() {
    return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): new VsphereVirtualDiskVolumeSourceBuilder().build());
  }
  public PersistentVolumeSpecFluentImpl.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item) {
    return withNewVsphereVolumeLike(getVsphereVolume() != null ? getVsphereVolume(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    PersistentVolumeSpecFluentImpl that = (PersistentVolumeSpecFluentImpl) o;
    if (!java.util.Objects.equals(accessModes, that.accessModes)) return false;

    if (!java.util.Objects.equals(awsElasticBlockStore, that.awsElasticBlockStore)) return false;

    if (!java.util.Objects.equals(azureDisk, that.azureDisk)) return false;

    if (!java.util.Objects.equals(azureFile, that.azureFile)) return false;

    if (!java.util.Objects.equals(capacity, that.capacity)) return false;

    if (!java.util.Objects.equals(cephfs, that.cephfs)) return false;

    if (!java.util.Objects.equals(cinder, that.cinder)) return false;

    if (!java.util.Objects.equals(claimRef, that.claimRef)) return false;

    if (!java.util.Objects.equals(csi, that.csi)) return false;

    if (!java.util.Objects.equals(fc, that.fc)) return false;

    if (!java.util.Objects.equals(flexVolume, that.flexVolume)) return false;

    if (!java.util.Objects.equals(flocker, that.flocker)) return false;

    if (!java.util.Objects.equals(gcePersistentDisk, that.gcePersistentDisk)) return false;

    if (!java.util.Objects.equals(glusterfs, that.glusterfs)) return false;

    if (!java.util.Objects.equals(hostPath, that.hostPath)) return false;

    if (!java.util.Objects.equals(iscsi, that.iscsi)) return false;

    if (!java.util.Objects.equals(local, that.local)) return false;

    if (!java.util.Objects.equals(mountOptions, that.mountOptions)) return false;

    if (!java.util.Objects.equals(nfs, that.nfs)) return false;

    if (!java.util.Objects.equals(nodeAffinity, that.nodeAffinity)) return false;

    if (!java.util.Objects.equals(persistentVolumeReclaimPolicy, that.persistentVolumeReclaimPolicy)) return false;

    if (!java.util.Objects.equals(photonPersistentDisk, that.photonPersistentDisk)) return false;

    if (!java.util.Objects.equals(portworxVolume, that.portworxVolume)) return false;

    if (!java.util.Objects.equals(quobyte, that.quobyte)) return false;

    if (!java.util.Objects.equals(rbd, that.rbd)) return false;

    if (!java.util.Objects.equals(scaleIO, that.scaleIO)) return false;

    if (!java.util.Objects.equals(storageClassName, that.storageClassName)) return false;

    if (!java.util.Objects.equals(storageos, that.storageos)) return false;

    if (!java.util.Objects.equals(volumeMode, that.volumeMode)) return false;

    if (!java.util.Objects.equals(vsphereVolume, that.vsphereVolume)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessModes,  awsElasticBlockStore,  azureDisk,  azureFile,  capacity,  cephfs,  cinder,  claimRef,  csi,  fc,  flexVolume,  flocker,  gcePersistentDisk,  glusterfs,  hostPath,  iscsi,  local,  mountOptions,  nfs,  nodeAffinity,  persistentVolumeReclaimPolicy,  photonPersistentDisk,  portworxVolume,  quobyte,  rbd,  scaleIO,  storageClassName,  storageos,  volumeMode,  vsphereVolume,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessModes != null && !accessModes.isEmpty()) { sb.append("accessModes:"); sb.append(accessModes + ","); }
    if (awsElasticBlockStore != null) { sb.append("awsElasticBlockStore:"); sb.append(awsElasticBlockStore + ","); }
    if (azureDisk != null) { sb.append("azureDisk:"); sb.append(azureDisk + ","); }
    if (azureFile != null) { sb.append("azureFile:"); sb.append(azureFile + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (cephfs != null) { sb.append("cephfs:"); sb.append(cephfs + ","); }
    if (cinder != null) { sb.append("cinder:"); sb.append(cinder + ","); }
    if (claimRef != null) { sb.append("claimRef:"); sb.append(claimRef + ","); }
    if (csi != null) { sb.append("csi:"); sb.append(csi + ","); }
    if (fc != null) { sb.append("fc:"); sb.append(fc + ","); }
    if (flexVolume != null) { sb.append("flexVolume:"); sb.append(flexVolume + ","); }
    if (flocker != null) { sb.append("flocker:"); sb.append(flocker + ","); }
    if (gcePersistentDisk != null) { sb.append("gcePersistentDisk:"); sb.append(gcePersistentDisk + ","); }
    if (glusterfs != null) { sb.append("glusterfs:"); sb.append(glusterfs + ","); }
    if (hostPath != null) { sb.append("hostPath:"); sb.append(hostPath + ","); }
    if (iscsi != null) { sb.append("iscsi:"); sb.append(iscsi + ","); }
    if (local != null) { sb.append("local:"); sb.append(local + ","); }
    if (mountOptions != null && !mountOptions.isEmpty()) { sb.append("mountOptions:"); sb.append(mountOptions + ","); }
    if (nfs != null) { sb.append("nfs:"); sb.append(nfs + ","); }
    if (nodeAffinity != null) { sb.append("nodeAffinity:"); sb.append(nodeAffinity + ","); }
    if (persistentVolumeReclaimPolicy != null) { sb.append("persistentVolumeReclaimPolicy:"); sb.append(persistentVolumeReclaimPolicy + ","); }
    if (photonPersistentDisk != null) { sb.append("photonPersistentDisk:"); sb.append(photonPersistentDisk + ","); }
    if (portworxVolume != null) { sb.append("portworxVolume:"); sb.append(portworxVolume + ","); }
    if (quobyte != null) { sb.append("quobyte:"); sb.append(quobyte + ","); }
    if (rbd != null) { sb.append("rbd:"); sb.append(rbd + ","); }
    if (scaleIO != null) { sb.append("scaleIO:"); sb.append(scaleIO + ","); }
    if (storageClassName != null) { sb.append("storageClassName:"); sb.append(storageClassName + ","); }
    if (storageos != null) { sb.append("storageos:"); sb.append(storageos + ","); }
    if (volumeMode != null) { sb.append("volumeMode:"); sb.append(volumeMode + ","); }
    if (vsphereVolume != null) { sb.append("vsphereVolume:"); sb.append(vsphereVolume + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class AwsElasticBlockStoreNestedImpl<N> extends AWSElasticBlockStoreVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNested<N>> implements PersistentVolumeSpecFluentImpl.AwsElasticBlockStoreNested<N>,Nested<N>{
    AwsElasticBlockStoreNestedImpl(AWSElasticBlockStoreVolumeSource item) {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this, item);
    }
    AwsElasticBlockStoreNestedImpl() {
      this.builder = new AWSElasticBlockStoreVolumeSourceBuilder(this);
    }
    AWSElasticBlockStoreVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withAwsElasticBlockStore(builder.build());
    }
    public N endAwsElasticBlockStore() {
      return and();
    }
    
  }
  class AzureDiskNestedImpl<N> extends AzureDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.AzureDiskNested<N>> implements PersistentVolumeSpecFluentImpl.AzureDiskNested<N>,Nested<N>{
    AzureDiskNestedImpl(AzureDiskVolumeSource item) {
      this.builder = new AzureDiskVolumeSourceBuilder(this, item);
    }
    AzureDiskNestedImpl() {
      this.builder = new AzureDiskVolumeSourceBuilder(this);
    }
    AzureDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withAzureDisk(builder.build());
    }
    public N endAzureDisk() {
      return and();
    }
    
  }
  class AzureFileNestedImpl<N> extends AzureFilePersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.AzureFileNested<N>> implements PersistentVolumeSpecFluentImpl.AzureFileNested<N>,Nested<N>{
    AzureFileNestedImpl(AzureFilePersistentVolumeSource item) {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this, item);
    }
    AzureFileNestedImpl() {
      this.builder = new AzureFilePersistentVolumeSourceBuilder(this);
    }
    AzureFilePersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withAzureFile(builder.build());
    }
    public N endAzureFile() {
      return and();
    }
    
  }
  class CephfsNestedImpl<N> extends CephFSPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.CephfsNested<N>> implements PersistentVolumeSpecFluentImpl.CephfsNested<N>,Nested<N>{
    CephfsNestedImpl(CephFSPersistentVolumeSource item) {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this, item);
    }
    CephfsNestedImpl() {
      this.builder = new CephFSPersistentVolumeSourceBuilder(this);
    }
    CephFSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withCephfs(builder.build());
    }
    public N endCephfs() {
      return and();
    }
    
  }
  class CinderNestedImpl<N> extends CinderPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.CinderNested<N>> implements PersistentVolumeSpecFluentImpl.CinderNested<N>,Nested<N>{
    CinderNestedImpl(CinderPersistentVolumeSource item) {
      this.builder = new CinderPersistentVolumeSourceBuilder(this, item);
    }
    CinderNestedImpl() {
      this.builder = new CinderPersistentVolumeSourceBuilder(this);
    }
    CinderPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withCinder(builder.build());
    }
    public N endCinder() {
      return and();
    }
    
  }
  class ClaimRefNestedImpl<N> extends ObjectReferenceFluentImpl<PersistentVolumeSpecFluentImpl.ClaimRefNested<N>> implements PersistentVolumeSpecFluentImpl.ClaimRefNested<N>,Nested<N>{
    ClaimRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ClaimRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withClaimRef(builder.build());
    }
    public N endClaimRef() {
      return and();
    }
    
  }
  class CsiNestedImpl<N> extends CSIPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.CsiNested<N>> implements PersistentVolumeSpecFluentImpl.CsiNested<N>,Nested<N>{
    CsiNestedImpl(CSIPersistentVolumeSource item) {
      this.builder = new CSIPersistentVolumeSourceBuilder(this, item);
    }
    CsiNestedImpl() {
      this.builder = new CSIPersistentVolumeSourceBuilder(this);
    }
    CSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withCsi(builder.build());
    }
    public N endCsi() {
      return and();
    }
    
  }
  class FcNestedImpl<N> extends FCVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.FcNested<N>> implements PersistentVolumeSpecFluentImpl.FcNested<N>,Nested<N>{
    FcNestedImpl(FCVolumeSource item) {
      this.builder = new FCVolumeSourceBuilder(this, item);
    }
    FcNestedImpl() {
      this.builder = new FCVolumeSourceBuilder(this);
    }
    FCVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withFc(builder.build());
    }
    public N endFc() {
      return and();
    }
    
  }
  class FlexVolumeNestedImpl<N> extends FlexPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.FlexVolumeNested<N>> implements PersistentVolumeSpecFluentImpl.FlexVolumeNested<N>,Nested<N>{
    FlexVolumeNestedImpl(FlexPersistentVolumeSource item) {
      this.builder = new FlexPersistentVolumeSourceBuilder(this, item);
    }
    FlexVolumeNestedImpl() {
      this.builder = new FlexPersistentVolumeSourceBuilder(this);
    }
    FlexPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withFlexVolume(builder.build());
    }
    public N endFlexVolume() {
      return and();
    }
    
  }
  class FlockerNestedImpl<N> extends FlockerVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.FlockerNested<N>> implements PersistentVolumeSpecFluentImpl.FlockerNested<N>,Nested<N>{
    FlockerNestedImpl(FlockerVolumeSource item) {
      this.builder = new FlockerVolumeSourceBuilder(this, item);
    }
    FlockerNestedImpl() {
      this.builder = new FlockerVolumeSourceBuilder(this);
    }
    FlockerVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withFlocker(builder.build());
    }
    public N endFlocker() {
      return and();
    }
    
  }
  class GcePersistentDiskNestedImpl<N> extends GCEPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.GcePersistentDiskNested<N>> implements PersistentVolumeSpecFluentImpl.GcePersistentDiskNested<N>,Nested<N>{
    GcePersistentDiskNestedImpl(GCEPersistentDiskVolumeSource item) {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this, item);
    }
    GcePersistentDiskNestedImpl() {
      this.builder = new GCEPersistentDiskVolumeSourceBuilder(this);
    }
    GCEPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withGcePersistentDisk(builder.build());
    }
    public N endGcePersistentDisk() {
      return and();
    }
    
  }
  class GlusterfsNestedImpl<N> extends GlusterfsPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.GlusterfsNested<N>> implements PersistentVolumeSpecFluentImpl.GlusterfsNested<N>,Nested<N>{
    GlusterfsNestedImpl(GlusterfsPersistentVolumeSource item) {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this, item);
    }
    GlusterfsNestedImpl() {
      this.builder = new GlusterfsPersistentVolumeSourceBuilder(this);
    }
    GlusterfsPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withGlusterfs(builder.build());
    }
    public N endGlusterfs() {
      return and();
    }
    
  }
  class HostPathNestedImpl<N> extends HostPathVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.HostPathNested<N>> implements PersistentVolumeSpecFluentImpl.HostPathNested<N>,Nested<N>{
    HostPathNestedImpl(HostPathVolumeSource item) {
      this.builder = new HostPathVolumeSourceBuilder(this, item);
    }
    HostPathNestedImpl() {
      this.builder = new HostPathVolumeSourceBuilder(this);
    }
    HostPathVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withHostPath(builder.build());
    }
    public N endHostPath() {
      return and();
    }
    
  }
  class IscsiNestedImpl<N> extends ISCSIPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.IscsiNested<N>> implements PersistentVolumeSpecFluentImpl.IscsiNested<N>,Nested<N>{
    IscsiNestedImpl(ISCSIPersistentVolumeSource item) {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this, item);
    }
    IscsiNestedImpl() {
      this.builder = new ISCSIPersistentVolumeSourceBuilder(this);
    }
    ISCSIPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withIscsi(builder.build());
    }
    public N endIscsi() {
      return and();
    }
    
  }
  class LocalNestedImpl<N> extends LocalVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.LocalNested<N>> implements PersistentVolumeSpecFluentImpl.LocalNested<N>,Nested<N>{
    LocalNestedImpl(LocalVolumeSource item) {
      this.builder = new LocalVolumeSourceBuilder(this, item);
    }
    LocalNestedImpl() {
      this.builder = new LocalVolumeSourceBuilder(this);
    }
    LocalVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withLocal(builder.build());
    }
    public N endLocal() {
      return and();
    }
    
  }
  class NfsNestedImpl<N> extends NFSVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.NfsNested<N>> implements PersistentVolumeSpecFluentImpl.NfsNested<N>,Nested<N>{
    NfsNestedImpl(NFSVolumeSource item) {
      this.builder = new NFSVolumeSourceBuilder(this, item);
    }
    NfsNestedImpl() {
      this.builder = new NFSVolumeSourceBuilder(this);
    }
    NFSVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withNfs(builder.build());
    }
    public N endNfs() {
      return and();
    }
    
  }
  class NodeAffinityNestedImpl<N> extends VolumeNodeAffinityFluentImpl<PersistentVolumeSpecFluentImpl.NodeAffinityNested<N>> implements PersistentVolumeSpecFluentImpl.NodeAffinityNested<N>,Nested<N>{
    NodeAffinityNestedImpl(VolumeNodeAffinity item) {
      this.builder = new VolumeNodeAffinityBuilder(this, item);
    }
    NodeAffinityNestedImpl() {
      this.builder = new VolumeNodeAffinityBuilder(this);
    }
    VolumeNodeAffinityBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withNodeAffinity(builder.build());
    }
    public N endNodeAffinity() {
      return and();
    }
    
  }
  class PhotonPersistentDiskNestedImpl<N> extends PhotonPersistentDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNested<N>> implements PersistentVolumeSpecFluentImpl.PhotonPersistentDiskNested<N>,Nested<N>{
    PhotonPersistentDiskNestedImpl(PhotonPersistentDiskVolumeSource item) {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this, item);
    }
    PhotonPersistentDiskNestedImpl() {
      this.builder = new PhotonPersistentDiskVolumeSourceBuilder(this);
    }
    PhotonPersistentDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withPhotonPersistentDisk(builder.build());
    }
    public N endPhotonPersistentDisk() {
      return and();
    }
    
  }
  class PortworxVolumeNestedImpl<N> extends PortworxVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.PortworxVolumeNested<N>> implements PersistentVolumeSpecFluentImpl.PortworxVolumeNested<N>,Nested<N>{
    PortworxVolumeNestedImpl(PortworxVolumeSource item) {
      this.builder = new PortworxVolumeSourceBuilder(this, item);
    }
    PortworxVolumeNestedImpl() {
      this.builder = new PortworxVolumeSourceBuilder(this);
    }
    PortworxVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withPortworxVolume(builder.build());
    }
    public N endPortworxVolume() {
      return and();
    }
    
  }
  class QuobyteNestedImpl<N> extends QuobyteVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.QuobyteNested<N>> implements PersistentVolumeSpecFluentImpl.QuobyteNested<N>,Nested<N>{
    QuobyteNestedImpl(QuobyteVolumeSource item) {
      this.builder = new QuobyteVolumeSourceBuilder(this, item);
    }
    QuobyteNestedImpl() {
      this.builder = new QuobyteVolumeSourceBuilder(this);
    }
    QuobyteVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withQuobyte(builder.build());
    }
    public N endQuobyte() {
      return and();
    }
    
  }
  class RbdNestedImpl<N> extends RBDPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.RbdNested<N>> implements PersistentVolumeSpecFluentImpl.RbdNested<N>,Nested<N>{
    RbdNestedImpl(RBDPersistentVolumeSource item) {
      this.builder = new RBDPersistentVolumeSourceBuilder(this, item);
    }
    RbdNestedImpl() {
      this.builder = new RBDPersistentVolumeSourceBuilder(this);
    }
    RBDPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withRbd(builder.build());
    }
    public N endRbd() {
      return and();
    }
    
  }
  class ScaleIONestedImpl<N> extends ScaleIOPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.ScaleIONested<N>> implements PersistentVolumeSpecFluentImpl.ScaleIONested<N>,Nested<N>{
    ScaleIONestedImpl(ScaleIOPersistentVolumeSource item) {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this, item);
    }
    ScaleIONestedImpl() {
      this.builder = new ScaleIOPersistentVolumeSourceBuilder(this);
    }
    ScaleIOPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withScaleIO(builder.build());
    }
    public N endScaleIO() {
      return and();
    }
    
  }
  class StorageosNestedImpl<N> extends StorageOSPersistentVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.StorageosNested<N>> implements PersistentVolumeSpecFluentImpl.StorageosNested<N>,Nested<N>{
    StorageosNestedImpl(StorageOSPersistentVolumeSource item) {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this, item);
    }
    StorageosNestedImpl() {
      this.builder = new StorageOSPersistentVolumeSourceBuilder(this);
    }
    StorageOSPersistentVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withStorageos(builder.build());
    }
    public N endStorageos() {
      return and();
    }
    
  }
  class VsphereVolumeNestedImpl<N> extends VsphereVirtualDiskVolumeSourceFluentImpl<PersistentVolumeSpecFluentImpl.VsphereVolumeNested<N>> implements PersistentVolumeSpecFluentImpl.VsphereVolumeNested<N>,Nested<N>{
    VsphereVolumeNestedImpl(VsphereVirtualDiskVolumeSource item) {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this, item);
    }
    VsphereVolumeNestedImpl() {
      this.builder = new VsphereVirtualDiskVolumeSourceBuilder(this);
    }
    VsphereVirtualDiskVolumeSourceBuilder builder;
    public N and() {
      return (N) PersistentVolumeSpecFluentImpl.this.withVsphereVolume(builder.build());
    }
    public N endVsphereVolume() {
      return and();
    }
    
  }
  
}