package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PersistentVolumeClaimVolumeSourceBuilder extends PersistentVolumeClaimVolumeSourceFluentImpl<PersistentVolumeClaimVolumeSourceBuilder> implements VisitableBuilder<PersistentVolumeClaimVolumeSource,PersistentVolumeClaimVolumeSourceBuilder>{
  public PersistentVolumeClaimVolumeSourceBuilder() {
    this(false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(Boolean validationEnabled) {
    this(new PersistentVolumeClaimVolumeSource(), validationEnabled);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PersistentVolumeClaimVolumeSource(), validationEnabled);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent,PersistentVolumeClaimVolumeSource instance) {
    this(fluent, instance, false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSourceFluent<?> fluent,PersistentVolumeClaimVolumeSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withClaimName(instance.getClaimName());
      fluent.withReadOnly(instance.getReadOnly());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSource instance) {
    this(instance,false);
  }
  public PersistentVolumeClaimVolumeSourceBuilder(PersistentVolumeClaimVolumeSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withClaimName(instance.getClaimName());
      this.withReadOnly(instance.getReadOnly());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PersistentVolumeClaimVolumeSourceFluent<?> fluent;
  Boolean validationEnabled;
  public PersistentVolumeClaimVolumeSource build() {
    PersistentVolumeClaimVolumeSource buildable = new PersistentVolumeClaimVolumeSource(fluent.getClaimName(),fluent.getReadOnly());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}