package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class LimitRangeListFluentImpl<A extends LimitRangeListFluent<A>> extends BaseFluent<A> implements LimitRangeListFluent<A>{
  public LimitRangeListFluentImpl() {
  }
  public LimitRangeListFluentImpl(LimitRangeList instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private ArrayList<LimitRangeBuilder> items = new ArrayList<LimitRangeBuilder>();
  private String kind;
  private ListMetaBuilder metadata;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToItems(int index,LimitRange item) {
    if (this.items == null) {this.items = new ArrayList<LimitRangeBuilder>();}
    LimitRangeBuilder builder = new LimitRangeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").add(index, builder); items.add(index, builder);}
    return (A)this;
  }
  public A setToItems(int index,LimitRange item) {
    if (this.items == null) {this.items = new ArrayList<LimitRangeBuilder>();}
    LimitRangeBuilder builder = new LimitRangeBuilder(item);
    if (index < 0 || index >= items.size()) { _visitables.get("items").add(builder); items.add(builder); } else { _visitables.get("items").set(index, builder); items.set(index, builder);}
    return (A)this;
  }
  public A addToItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    if (this.items == null) {this.items = new ArrayList<LimitRangeBuilder>();}
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A addAllToItems(Collection<LimitRange> items) {
    if (this.items == null) {this.items = new ArrayList<LimitRangeBuilder>();}
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").add(builder);this.items.add(builder);} return (A)this;
  }
  public A removeFromItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeAllFromItems(Collection<LimitRange> items) {
    for (LimitRange item : items) {LimitRangeBuilder builder = new LimitRangeBuilder(item);_visitables.get("items").remove(builder);if (this.items != null) {this.items.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromItems(Predicate<LimitRangeBuilder> predicate) {
    if (items == null) return (A) this;
    final Iterator<LimitRangeBuilder> each = items.iterator();
    final List visitables = _visitables.get("items");
    while (each.hasNext()) {
      LimitRangeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<LimitRange> getItems() {
    return items != null ? build(items) : null;
  }
  public List<LimitRange> buildItems() {
    return items != null ? build(items) : null;
  }
  public LimitRange buildItem(int index) {
    return this.items.get(index).build();
  }
  public LimitRange buildFirstItem() {
    return this.items.get(0).build();
  }
  public LimitRange buildLastItem() {
    return this.items.get(items.size() - 1).build();
  }
  public LimitRange buildMatchingItem(Predicate<LimitRangeBuilder> predicate) {
    for (LimitRangeBuilder item: items) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingItem(Predicate<LimitRangeBuilder> predicate) {
    for (LimitRangeBuilder item: items) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withItems(List<LimitRange> items) {
    if (this.items != null) { _visitables.get("items").clear();}
    if (items != null) {this.items = new ArrayList(); for (LimitRange item : items){this.addToItems(item);}} else { this.items = null;} return (A) this;
  }
  public A withItems(io.fabric8.kubernetes.api.model.LimitRange... items) {
    if (this.items != null) {this.items.clear(); _visitables.remove("items"); }
    if (items != null) {for (LimitRange item :items){ this.addToItems(item);}} return (A) this;
  }
  public Boolean hasItems() {
    return items != null && !items.isEmpty();
  }
  public LimitRangeListFluentImpl.ItemsNested<A> addNewItem() {
    return new LimitRangeListFluentImpl.ItemsNestedImpl();
  }
  public LimitRangeListFluentImpl.ItemsNested<A> addNewItemLike(LimitRange item) {
    return new LimitRangeListFluentImpl.ItemsNestedImpl(-1, item);
  }
  public LimitRangeListFluentImpl.ItemsNested<A> setNewItemLike(int index,LimitRange item) {
    return new LimitRangeListFluentImpl.ItemsNestedImpl(index, item);
  }
  public LimitRangeListFluentImpl.ItemsNested<A> editItem(int index) {
    if (items.size() <= index) throw new RuntimeException("Can't edit items. Index exceeds size.");
    return setNewItemLike(index, buildItem(index));
  }
  public LimitRangeListFluentImpl.ItemsNested<A> editFirstItem() {
    if (items.size() == 0) throw new RuntimeException("Can't edit first items. The list is empty.");
    return setNewItemLike(0, buildItem(0));
  }
  public LimitRangeListFluentImpl.ItemsNested<A> editLastItem() {
    int index = items.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last items. The list is empty.");
    return setNewItemLike(index, buildItem(index));
  }
  public LimitRangeListFluentImpl.ItemsNested<A> editMatchingItem(Predicate<LimitRangeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<items.size();i++) { 
    if (predicate.test(items.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching items. No match found.");
    return setNewItemLike(index, buildItem(index));
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ListMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ListMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ListMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink) {
    return (A)withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
  }
  public LimitRangeListFluentImpl.MetadataNested<A> withNewMetadata() {
    return new LimitRangeListFluentImpl.MetadataNestedImpl();
  }
  public LimitRangeListFluentImpl.MetadataNested<A> withNewMetadataLike(ListMeta item) {
    return new LimitRangeListFluentImpl.MetadataNestedImpl(item);
  }
  public LimitRangeListFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public LimitRangeListFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ListMetaBuilder().build());
  }
  public LimitRangeListFluentImpl.MetadataNested<A> editOrNewMetadataLike(ListMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LimitRangeListFluentImpl that = (LimitRangeListFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(items, that.items)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  items,  kind,  metadata,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (items != null && !items.isEmpty()) { sb.append("items:"); sb.append(items + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ItemsNestedImpl<N> extends LimitRangeFluentImpl<LimitRangeListFluentImpl.ItemsNested<N>> implements LimitRangeListFluentImpl.ItemsNested<N>,Nested<N>{
    ItemsNestedImpl(int index,LimitRange item) {
      this.index = index;
      this.builder = new LimitRangeBuilder(this, item);
    }
    ItemsNestedImpl() {
      this.index = -1;
      this.builder = new LimitRangeBuilder(this);
    }
    LimitRangeBuilder builder;
    int index;
    public N and() {
      return (N) LimitRangeListFluentImpl.this.setToItems(index,builder.build());
    }
    public N endItem() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ListMetaFluentImpl<LimitRangeListFluentImpl.MetadataNested<N>> implements LimitRangeListFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ListMeta item) {
      this.builder = new ListMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ListMetaBuilder(this);
    }
    ListMetaBuilder builder;
    public N and() {
      return (N) LimitRangeListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}