package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LimitRangeBuilder extends LimitRangeFluentImpl<LimitRangeBuilder> implements VisitableBuilder<LimitRange,LimitRangeBuilder>{
  public LimitRangeBuilder() {
    this(false);
  }
  public LimitRangeBuilder(Boolean validationEnabled) {
    this(new LimitRange(), validationEnabled);
  }
  public LimitRangeBuilder(LimitRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public LimitRangeBuilder(LimitRangeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LimitRange(), validationEnabled);
  }
  public LimitRangeBuilder(LimitRangeFluent<?> fluent,LimitRange instance) {
    this(fluent, instance, false);
  }
  public LimitRangeBuilder(LimitRangeFluent<?> fluent,LimitRange instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LimitRangeBuilder(LimitRange instance) {
    this(instance,false);
  }
  public LimitRangeBuilder(LimitRange instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LimitRangeFluent<?> fluent;
  Boolean validationEnabled;
  public LimitRange build() {
    LimitRange buildable = new LimitRange(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}